/*
	$Id: menubar_default.cpp,v 1.20 2001/12/16 19:18:08 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "menubar_default.h"
#include "API/GUI/stylemanager_default.h"

CL_MenuBar_Default::CL_MenuBar_Default(
	CL_MenuBar *_menubar,
	const CL_ComponentOptions &options,
	CL_StyleManager_Default *style)
: CL_ComponentStyle(_menubar), menubar(_menubar)
{
	this->style = style;

	resources = style->get_resources();
	
	slot_paint = menubar->sig_paint().connect(this, &CL_MenuBar_Default::on_paint);
}
/*
void CL_MenuBar_Default::adjust_size()
{
	int max_height = 0;
	int x = 0;
	
	std::list<CL_Component *>::iterator it;
	std::list<CL_Component *> &children = menubar->get_children();

	// Find maximum height of all items
	for (
		it = children.begin();
		it != children.end();
		it++)
	{
		CL_MenuItem *menuitem = (CL_MenuItem *)(*it);
		CL_MenuItem_Default *menuitem_default = (CL_MenuItem_Default *)menuitem->get_impl();

		int height = menuitem_default->calc_height();
		if(height > max_height)
			max_height = height;
	}

	// Set size and position of items
	for (
		it = children.begin();
		it != children.end();
		it++)
	{
		CL_MenuItem *menuitem = (CL_MenuItem *)(*it);
		CL_MenuItem_Default *menuitem_default = (CL_MenuItem_Default *)menuitem->get_impl();

		int pos = 4;

		menuitem_default->set_surface_check_pos(pos);
		pos += menuitem_default->calc_surface_check_width();

		menuitem_default->set_surface_icon_pos(pos);
		pos += menuitem_default->calc_surface_icon_width();
	
		menuitem_default->set_text_pos(pos);
		pos += menuitem_default->calc_text_width();
	
		menuitem_default->set_surface_submenu_pos(pos);
		pos += menuitem_default->calc_surface_submenu_width();

		CL_Rect position = CL_Rect(x, 0, x + pos, max_height);

		menuitem->set_position(position);
		menuitem_default->set_draw_style(false);

		x += pos;
	}

	// If any child is taller than parent, resize parent
	CL_Rect parent_rect = menubar->get_position();
	CL_Rect children_rect = menubar->get_children_rect();
	if(children_rect.get_height() > parent_rect.get_height())
		menubar->set_size(parent_rect.get_width(), children_rect.get_height());
}
*/
void CL_MenuBar_Default::on_paint()
{
	int width = menubar->get_width();
	int height = menubar->get_height();
	
	style->draw_box(0, 0, width, height, GUICOLOR_BRIGHT_SHADE, GUICOLOR_DARK_SHADE);
	style->fill_rect(1, 1, width - 1, height - 1, GUICOLOR_WINDOW_NORMAL);
}
