/*
	$Id: treeview_item_generic.h,v 1.3 2001/12/28 20:30:06 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_treeview_item_generic
#define header_treeview_item_generic

#include "API/GUI/treeview_item.h"

class CL_TreeView_Item_Generic
{
// Construction:
public:
	CL_TreeView_Item_Generic(CL_TreeView_Item *self, const std::string &text);
	~CL_TreeView_Item_Generic() {};

// Attributes:
public:
	bool has_subtree() const;

	std::string text;
	
	bool opened;

// Operations:
public:
	void set_text(const std::string &text);

// Signals:
public:
	CL_Signal_v0 sig_clicked;

// Slots:
private:
	CL_Slot slot_key_down;
	CL_Slot slot_set_options;

// Callbacks:
private:
	void on_key_down(CL_Component *comp, CL_InputDevice *device, const CL_Key &key);
	void on_set_options(const CL_ComponentOptions &options);

// Implementation:
private:
	CL_TreeView_Item *item;
};

#endif
