/*
    alpha test example... uses the Magick Provider on purpose
*/

#include <ClanLib/core.h>
#include <ClanLib/magick.h>

class SurfaceApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "alpha test application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupMagick::init();
		CL_SetupCore::init_display();
	}

	virtual void deinit_modules()
	{
		CL_SetupMagick::deinit();
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		try
		{
			// Set mode: 640x480 16 bpp
			CL_Display::set_videomode(640, 480, 16, true);
		
			CL_Canvas *canvas = new CL_Canvas(640, 480, 1);

			canvas->lock();
			unsigned int* data = (unsigned int*) canvas->get_data();
			for (int y=0; y<480; y++)
			{
				for (int x=0; x<640; x++)
				{
				        data[x + 640*y] = CL_Color::get_color(RGBA8888, 
						1.0f,
						0.0f,
						0.0f,
						float (y)/ 480.0f); 
				}
			}			
			canvas->unlock();
		
	 
			// Load surface from jpg file:
			CL_Surface *surface = CL_MagickProvider::create("back.jpg", NULL, RGB565);
			CL_Surface *gradient = CL_Surface::create(canvas, true);
		
			float alpha = 0;
			int frames = 0;
			int time = CL_System::get_time();

			// Loop until the user hits escape:
			while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
				// Draw surface:
				CL_Display::clear_display();
				surface->put_screen(0, 0);
				
				//CL_Display::fill_rect(0, 0, 319, 199, 1.0, 1.0, 1.0, 1.0);
				
				alpha += 0.01f;
				if (alpha>1.0)
					alpha -= 1.0f;
				frames++;

				//for (int y=30; y<170; y++)
				//	CL_Display::draw_line(30, y, 290, y, 0.0, 0.0, 1.0, alpha);
				
				CL_Display::fill_rect(30, 30, 290, 170, 0.0, 0.0, 1.0, alpha);

				// gradient->put_screen(0,0);
			
				// Flip front and backbuffer. This makes the changes visible:
				CL_Display::flip_display();
			
				// Update keyboard input and handle system events:
				// Exits the loop if ClanLib requests shutdown - for instance if
				// someone closes the window.
				CL_System::keep_alive();
			}
			float fps = frames / ((float) (CL_System::get_time() - time) / 1000.0f);
			std::cout << "fps : " << fps << std::endl;

			delete surface;
			delete gradient;
		
			
		
		}
		catch(CL_Error error)
		{
			std::cout << "Exception caught : " << error.message.c_str() << std::endl;			
			return -1;
		}
		return 0;
	
	}
} app;
