/*
	Simple Event Chains Application

	note that the try/catch is not required but should be added 
	to every ClanLib application.
*/
#include <ClanLib/core.h>

class EventChainsApp :
	public CL_ClanApplication,
	public CL_Event_ButtonPress,
	public CL_Event_ButtonRelease,
	public CL_Event_MouseMove,
	public CL_Event_MouseEnter,
	public CL_Event_MouseExit
{
public:
	virtual char *get_title() { return "Event chains application"; }
	virtual void init_modules() 
	{ 
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}
	virtual void deinit_modules() 
	{ 
		CL_SetupCore::deinit_display();
		CL_SetupCore::deinit();
	}
	virtual int main(int, char **)
	{
		try
		{
			quit = false;
			CL_Display::set_videomode(320, 200, 16, false, false);
			
			CL_Input::chain_button_press.push_back(this);
			CL_Input::chain_button_release.push_back(this);
			CL_Input::chain_mouse_move.push_back(this);
			CL_Input::chain_mouse_enter.push_back(this);
			CL_Input::chain_mouse_exit.push_back(this);
			
			while (!quit)
			{
				CL_System::keep_alive();
				CL_System::sleep(20);
			}		
		
		}
		catch (CL_Error err)
		{
			cout << "Exception caught: " << err.message.c_str() << endl;
			return -1;
		}		
		return 0;
	}

	virtual bool on_button_press(CL_InputDevice *device, const CL_Key &key)
	{
		if (key.ascii != -1)
		{
			cout << "id=" << key.id 
			     << " ascii=" << (char)key.ascii
			     << " pressed at x:" << key.x << " y:" << key.y << endl;
		} else {
			cout << "id=" << key.id 
			     << " pressed at x:" << key.x << " y:" << key.y << endl;			
		}
		if (key.id == CL_KEY_ESCAPE) quit = true;
		return true;
	}
	
	virtual bool on_button_release(CL_InputDevice *device, const CL_Key &key)
	{
		if (key.ascii != -1) 
		{
			cout << "id=" << key.id 
			     << " ascii=" << (char)key.ascii
			     << " released at x:" << key.x << " y:" << key.y << endl;
		} else {
			cout << "id=" << key.id 
			     << " released at x:" << key.x << " y:" << key.y << endl;
		}
		return true;
	}
	
	virtual bool on_mouse_move(CL_InputDevice *device)
	{
		cout << "mouse moved" << endl;
		return true;
	}
	
	virtual bool on_mouse_enter(CL_InputDevice *device)
	{
		cout << "mouse entered" << endl;
		return true;
	}	
	
	virtual bool on_mouse_exit(CL_InputDevice *device)
	{
		cout << "mouse exited" << endl;
		return true;
	}	
	
	bool quit;
	
} app;
