/*
	$Id: resourcetype.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Resources"

#ifndef header_resourcetype
#define header_resourcetype

#include "../../stl.h"

class CL_ResourceManager;
class CL_ResourceOptions;
class CL_Resource;

class CL_ResourceType
{
public:
	CL_ResourceType(std::string type);
	virtual ~CL_ResourceType();

	virtual const std::string &get_type() const { return type; }

	virtual CL_Resource *create_from_location(
		std::string name,
		std::string location,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent)=0;

	virtual CL_Resource *create_from_serialization(
		std::string name,
		CL_ResourceManager *parent)=0;

	static std::list<CL_ResourceType*> resource_types;

private:
	std::string type;
};

#endif
