/*
	$Id: static_provider_raw.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Simple sample support.
*/

//! component="Static SoundProviders"

#ifndef header_static_provider_raw
#define header_static_provider_raw

#include "../../stl.h"
#include "../Sound/static_soundprovider.h"
#include "../Sound/soundbuffer.h"

class CL_Sample_RawData : public CL_StaticSoundProvider
//: Static sample in a raw PCM format (no header in file).
{
public:
	static CL_SoundBuffer *create(
		unsigned char *sound_data,
		int data_size,
		int bytes_per_sample,
		bool stereo,
		int frequency=22050)
	{
		return CL_SoundBuffer::create(
			new CL_Sample_RawData(
				sound_data,
				data_size,
				bytes_per_sample,
				stereo,
				frequency),
			true);
	}

	CL_Sample_RawData(
		unsigned char *sound_data,
		int data_size,
		int bytes_per_sample,
		bool stereo,
		int frequency=22050)
	{
		load_data(
			sound_data,
			data_size,
			bytes_per_sample,
			stereo,
			frequency);
	}

	virtual ~CL_Sample_RawData()
	{
		delete[] sample_data;
	}

	virtual void lock()
	{
		return;
	}

	virtual void unlock()
	{
//		delete[] sample_data;
//		sample_data = NULL;
	}

	virtual SoundFormat get_format() const
	{
		return sample_format;
	}

	virtual int data_size() const
	{
		return sample_size;
	}

	virtual void *get_data() const
	{
		return sample_data;
	}

	virtual int get_frequency() const
	{
		return sample_freq;
	}
private:
	struct WAVE_FORMAT
	{
		short formatTag;
		short nChannels;
		int nSamplesPerSec;
		int nAvgBytesPerSec;
		short nBlockAlign;
	};

	unsigned char *sample_data;
	SoundFormat sample_format;
	int sample_size;
	int sample_freq;

	void load_data(
		unsigned char *sound_data,
		int data_size,
		int bytes_per_sample,
		bool stereo,
		int frequency=22050)
	{
//		WAVE_FORMAT format;

		sample_size = data_size;
		sample_freq = frequency;

		sample_data = new unsigned char[sample_size];
		memcpy(sample_data, sound_data, sample_size);

		if (stereo && bytes_per_sample == 2) sample_format = sf_16bit_signed_stereo;
		else if (stereo && bytes_per_sample == 1) sample_format = sf_8bit_signed_stereo;
		else if (!stereo && bytes_per_sample == 2) sample_format = sf_16bit_signed;
		else if (!stereo && bytes_per_sample == 1) sample_format = sf_8bit_signed;
		else
		{
			std::cout << "Invalid sample format" << std::endl;
			exit(1);
//			throw new CL_Error_SampleRawData("Invalid sample format", __FILE__, __LINE__);
		}
	}
};

#endif
