
//! component="System"

#ifndef header_system
#define header_system

class CL_System
//: Generic functions that didn't fit in other places.
{
public:
	static void keep_alive();
	// Checks for system events, updates input and other stuff.

	static void sleep(int millis);
	// Sleep for 'millis' milliseconds.

	static unsigned int get_time();
	// Get the current time (since system boot), in milliseconds.

	static void suspend_time();
	// Suspend the time. get_time() will continue to return the same value
	// until resume_time() is called.

	static void resume_time();
	// Resumes the time. get_time() will return the current time again.
	
	static bool detect_mmx();
	// Returns true if MMX technology is available on this CPU.
	
	static bool detect_3dnow();
	// Returns true if 3DNow! technology is available on this CPU.
};

#endif
