/*
    clanMPEG - ClanLib MPEG Player Library
    Copyright (C) 1999  Loki Entertainment Software
    Copyright (C) 1999  Daniel Vogel

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef header_mpeglib
#define header_mpeglib

#include "../core.h"

class MPEGfile;

typedef void(*CL_MPEG_DisplayCallback)(CL_Target* dst, int x, int y,
                                     unsigned int w, unsigned int h);

enum CL_MPEG_Status
{
	CL_MPEG_ERROR = -1,
	CL_MPEG_STOPPED,
	CL_MPEG_PLAYING
};

class CL_MPEG
{

public:
	
	CL_MPEG(const char *filename, bool video = true, 
		bool audio = true);

	~CL_MPEG();
	
	void set_audio(bool flag);
	void set_video(bool flag);
	void set_double(bool flag);
	void set_loop(bool flag);
	void set_volume(int volume);
	void move(int x, int y);
	
	bool has_video() { return m_has_audio; }
	bool has_audio() { return m_has_video; }

	unsigned int get_width() { return m_width; }
	unsigned int get_height() { return m_height; }
	unsigned int get_current_frame() { return 0;}

	double get_current_fps() { return 0;}
	CL_MPEG_Status get_status();

	void play();
	void pause();
	void stop();
	void rewind();

	void set_display(CL_Target* dst, CL_Mutex* surfLock,
			 CL_MPEG_DisplayCallback callback);
	void set_display(CL_Target* dst);

	char* get_error(); 

private:

	bool m_has_audio, m_has_video;
	bool m_double, m_loop;
	unsigned int m_width, m_height;

	MPEGfile* obj;
};

/*
extern void SMPEG_renderFrame( SMPEG* mpeg, int framenum, CL_Target* dst,
                               int x, int y );

extern void SMPEG_renderFinal( SMPEG* mpeg, CL_Target* dst, int x, int y );
*/
#endif /* header_mpeglib */
