/*
	$Id: target_be.cpp,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <API/Core/Display/palette.h>
#include <Core/Display/Be/target_be.h>

CL_Target_Be::CL_Target_Be()
{
	clws = ((LibApplication*)be_app)->clanscreen;
}

CL_Target_Be::~CL_Target_Be()
{
}

bool CL_Target_Be::is_video()
{
	return (clws->is_connected());
}

void CL_Target_Be::lock()
{
//	return (clws->get_data()!=NULL);
}
	
void CL_Target_Be::unlock()
{
}

void *CL_Target_Be::get_data()
{
	return clws->get_data();
}

unsigned int CL_Target_Be::get_width()
{
	return clws->get_width();
}

unsigned int CL_Target_Be::get_height()
{
	return clws->get_width();
}

unsigned int CL_Target_Be::get_pitch()
{
	return clws->get_pitch();
}
	
unsigned int CL_Target_Be::get_depth()
{
	return clws->get_depth();
}

unsigned int CL_Target_Be::get_red_mask()
{
	return ((int)((pow(2,5))-1) << (6 + 5));
}

unsigned int CL_Target_Be::get_green_mask()
{
	return ((int)(pow(2,6))-1) << 5;
}

unsigned int CL_Target_Be::get_blue_mask()
{
	return (int)(pow(2,5))-1;
}

unsigned int CL_Target_Be::get_alpha_mask()
{
	return 0;
}

CL_Palette *CL_Target_Be::get_palette()
{
	return NULL;
}
