/*
	$Id: input.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <API/Core/Input/input.h>
#include <API/Core/Input/inputdevice.h>
#include <API/Core/Input/inputbutton.h>
#include <API/Core/Input/inputcursor.h>
#include <API/Core/Input/keyboard.h>
#include <API/Core/Input/mouse.h>

std::vector<CL_Keyboard*> CL_Input::keyboards;
std::vector<CL_InputDevice*> CL_Input::joysticks;
std::vector<CL_InputDevice*> CL_Input::pointers;

CL_EventChain_ButtonPress CL_Input::chain_button_press;
CL_EventChain_ButtonRelease CL_Input::chain_button_release;
CL_EventChain_MouseMove CL_Input::chain_mouse_move;
CL_EventChain_MouseEnter CL_Input::chain_mouse_enter;
CL_EventChain_MouseExit CL_Input::chain_mouse_exit;

bool CL_Keyboard::get_keycode(int button_no)
{
	return CL_Input::keyboards[0]->get_button(button_no)->is_pressed();
}

int CL_Mouse::get_x()
{
	return (int) CL_Input::pointers[0]->get_cursor(0)->get_x();
}

int CL_Mouse::get_y()
{
	return (int) CL_Input::pointers[0]->get_cursor(0)->get_y();
}

bool CL_Mouse::left_pressed()
{
	return CL_Input::pointers[0]->get_button(0)->is_pressed();
}

bool CL_Mouse::middle_pressed()
{
	return CL_Input::pointers[0]->get_button(1)->is_pressed();
}

bool CL_Mouse::right_pressed()
{
	return CL_Input::pointers[0]->get_button(2)->is_pressed();
}
