/*
	$Id: implementation_glx.cpp,v 1.2 2000/04/25 21:40:16 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Initialization functions for XWindow implementation.
		(modified for GLX implementation)

*/

#include "Core/precomp.h"

#ifdef USE_OPENGL

#include "implementation_xwindow.h"
#include "implementation_glx.h"

#include "API/Core/Display/display.h"
#include "API/Core/Input/input.h"

#include "Core/Display/X11/display_xwindow.h"
#include "Core/Input/X11/mouse_x11.h"
#include "Core/Input/X11/keyboard_x11.h"
#include "Core/Input/X11/joystick_linux.h"

#include "GL/GLX/displaycard_glx.h"

extern "C"
{
	char* clan_module_identify()
	{
		return "GLX target";
	}

	char* clan_module_abbreviation()
	{
		return "glx";
	}

	void clan_module_init()
	{
		CL_Implementation_GLX::add_display();
	}
}

char* glx_identify()
{
	return clan_module_identify();
}

char* glx_abbreviation()
{
	return clan_module_abbreviation();
}

void glx_init()
{
	clan_module_init();
}

void CL_Implementation_GLX::add_display()
{
	if (CL_Implementation_XWindow::init() == false)
	{
		std::cout << "ClanLib: Failed to open display. No X11 display available." << std::endl;
		exit(-1);	// should it exit here? added exit - dv
	}

	CL_GLX_DisplayCard *card = new CL_GLX_DisplayCard(
		CL_Implementation_XWindow::dpy,
		CL_Implementation_XWindow::root,
		CL_Implementation_XWindow::display_counter);

	CL_Display::cards.push_back(card);

	CL_Input::keyboards.push_back(new CL_XWindowKeyboard(card));
	CL_Input::pointers.push_back(new CL_Mouse_XWin(card));

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)

	CL_LinuxJoystick *joy = new CL_LinuxJoystick();
	if (joy->init())
		CL_Input::joysticks.push_back(joy);
	else
		delete joy;

#endif

	CL_Implementation_XWindow::display_counter+=3;
}

#endif
