/*
	$Id: cl_gapplication.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
*/
#include "../API/GUI/cl_gapplication.h"
//#include "udebug.h"
//#include "ulogo.h"
#include <assert.h>
//#define NOTRACE
//#include "trace.h"

CL_GApplication* CL_GApplication::Instance = NULL;

//CL_GApplication::CL_GApplication(int argc, char **argv) :
CL_GApplication::CL_GApplication() :
  CL_GObject(),
  rootWindow_(0),
//lp  mouse_(0),
//lp  resources_(0),
  startup_(true),
  shutdown_(false),
  running_(false),
//  argc_(argc),
//  argv_(argv),
  ticks_(0),
  focus_(true),
  iconified_(false)
{
//lp  UOBJECT_INIT(CL_GApplication);
 
  if(CL_GApplication::Instance != NULL)
    {
      cerr << "only one instance of CL_GApplication allowed." << endl;
      assert(false);
    }

  //setting the global app pointer....
  CL_GApplication::Instance = this;

  // set up the event queue
  eventqueue = new deque<CL_GEvent*>;

/* lp
  // Initialize SDL
  debugN(17,cerr << "trying to initialize SDL.. ";);
  if ( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0 )
  {
      cerr << " Couldn't initialize: " << SDL_GetError() << endl;
      exit(1);
    }
  debugN(17,cerr << " OK." << endl;);

#if !defined(__WIN32__)
  // for a clean exit
  atexit(SDL_Quit);
#endif

  debugN(17,cerr << "Enabling SDL Unicode support." << endl;);
  SDL_EnableUNICODE(1);

  resources_ = new UResources();
  
  mixer_ = new UMixer();
  
  if(!mixer_->audioAvailable())
    {
      debugN(17,cerr<<"Audio init failed. deleting mixer."<<endl;);
      delete mixer_;
      mixer_ = NULL;
    }

  soundMapper_ = new USoundMapper();

  keyTable_ = new SDL_keysym [KEY_TABLE_SIZE];
  delayTable_ = new unsigned char [KEY_TABLE_SIZE];
  for(int i=0; i < KEY_TABLE_SIZE; i++)
    {
      keyTable_[i].sym = SDLK_UNKNOWN;
      delayTable_[i] = 0;
    }
lp */
}
  

CL_GApplication::~CL_GApplication()
{
/* lp
  debugN(17,cerr << "CL_GApplication: removing mouse...";);
  if(mouse_ != 0)
    delete mouse_;

  debugN(17,
	 cerr << "OK." << endl;
	 cerr << "CL_GApplication: removing widget tree...";
	 );
*/
	TRACEMSG("CL_GApplication removing widget tree...");
  if(rootWindow_ != 0)
    delete rootWindow_;

    delete eventqueue;
    delete keyboard;
    
//  debugN(17,cerr << "OK." << endl;);
	TRACEMSG("OK.");
/* lp
  if(soundMapper_ != 0)
    delete soundMapper_;

  if(mixer_ != 0)
    delete mixer_;

  delete[] keyTable_;

  //the last one turns out the lights :)
  if(resources_ != 0)
    delete resources_;
lp */
}
/* lp
void CL_GApplication::init(int resX, int resY, int bpp,
		   bool fullscreen, const USurface* icon)
*/
void CL_GApplication::init(int resX, int resY, int bpp, bool fullscreen)
{
  if(rootWindow_ != NULL)
    {
      cerr << "CL_GApplication::init(..) may only be called once ! " << endl;
      assert(false);
    }
/* lp
  if(icon)
    {
      debugN(17,cerr<<"setting window icon..."<<endl;);
      //set the given surface as icon for our windows
      SDL_WM_SetIcon(icon->sdlSurface_,NULL);
      debugN(17,cerr<<"ok."<<endl;);
    }
  else
    {
      //otherwise put in a nice libu logo :)

      debugN(17,cerr<<"creating logo.." << endl;);
      ULogo* logo = new ULogo();
      debugN(17,cerr<<"success."<<endl;);
      debugN(17,cerr<<"setting window icon..."<<endl;);
      //set the logo as icon for our windows
      SDL_WM_SetIcon(logo->sdlSurface_,NULL);
      //now we don't need the logo anymore
      delete logo;
      debugN(17,cerr<<"ok."<<endl;);
    }
lp */
//  debugN(17,cerr <<"creating RootWidget...";);
	TRACEMSG("Setting video mode to:" <<resX<<"x"<<resY<<"x"<<bpp);
	CL_Display::set_videomode(resX, resY, bpp);
	TRACEMSG("OK.");

	TRACEMSG("creating RootWidget...");
  rootWindow_ = new CL_GRootWindow(resX, resY, bpp, fullscreen);
  assert(rootWindow_);
//  debugN(17,cerr <<"success." << endl;);
	TRACEMSG("OK.");
/* lp
  debugN(17,cerr<<"creating UMouse ...";);
  mouse_ = UMouse::create();
  assert(mouse_);
  debugN(17,cerr<<"success." << endl;);
*/

  //disable SDL cursor... we use a software mousecursor
//lp  SDL_ShowCursor(0);

	keyboard = new CL_InputBuffer();
}


int CL_GApplication::exec()
{
  if(rootWindow_ == NULL)
    {
      cerr <<"CL_GApplication has no rootwindow." << endl;
      return -1;
    }

  int returnVal;


  startupProc();


  startup_ = false;


  returnVal = eventloop();
  shutdown_ = true;


  shutdownProc();


  return returnVal;
}

bool CL_GApplication::handleEvent(const CL_GEvent* event)
{
  if(event->type() == CL_GEvent::MOUSEMOTION)
    {
//      mouse_->move(((CL_GMouseEvent*)event)->position());
    }
  else if(event->type() == CL_GEvent::LOSTFOCUS)
    {
      focus_ = false;
    }
  else if(event->type() == CL_GEvent::GOTFOCUS)
    {
      focus_ = true;
    }
    else if (event->type() == CL_GEvent::ICONIFIED)
    {
      iconified_ = true;
    }
  else if (event->type() == CL_GEvent::RESTORED)
    {
      iconified_ = false;
    }
  //not handled the app might want to know about these, too
  return false;

}

CL_GEvent* CL_GApplication::keyrepeat()
{

  //this is totally overkill .........
  //it should be sufficient to remember one key !
/* lp
  Uint8* keys;
  int numkeys;
  CL_GEvent* event = 0;

  keys = SDL_GetKeyState(&numkeys);

  if(numkeys > 0)
    {
      //at least one key pressed ...
      for(int i=0; i < KEY_TABLE_SIZE; i++)
	{

	  if(keys[i])
	    {
	      if((keyTable_[i].sym != 0) && (event == 0))
		{
		  if(delayTable_[i] > KEY_DELAY)
		    {
		      event = new UKeyEvent(keyTable_[i].sym,
					    keyTable_[i].mod,
					    UKeyEvent::PRESSED,
					    keyTable_[i].unicode);
		      delayTable_[i]=KEY_DELAY - KEY_REPEAT;
		    }
		  else
		    {
		      delayTable_[i]++;
		    }
 		}
	      numkeys --;
	    }
	  else
	    {
	      //reset this key
	      keyTable_[i].sym = SDLK_UNKNOWN;
	      delayTable_[i] = 0;
	    }
	
	  if(numkeys == 0)
	    break;
	}
    }

  return event;
 */
 return 0; //lp
}

int CL_GApplication::eventloop()
{

  int result = 0;
  running_ = true;

//lp  SDL_Event sdl_event;
  CL_GEvent *event = 0;

  bool handled=false;

  Uint32 lastticks;
  Uint32 tick;
  Uint32 tick50=0;
  Uint32 tick500 = 0;
  Uint32 tick100 = 0;

// lp. Must get something similar from ClanLib
//  lastticks = SDL_GetTicks();

  while(running_)
    {

// called in poll_events
//    	CL_System::keep_alive();

      //Timer stuff
//lp      tick = SDL_GetTicks();
	tick = CL_System::get_time();
      tick50 += tick - lastticks;
      lastticks = tick;

      //limit to 50 revolutions per second
      if(tick50 < 20)
	{
//	  SDL_Delay(20 - tick50);
		CL_System::sleep(20-tick50); //lp
	  tick50 = 20;
	}

      ticks_ += tick50;
      tick500 += tick50;
      tick100 += tick50;


      if(tick50 > 50)
	{

	  //emit fast timer signal with overrun value
	  emit timer(tick50-50);

	  tick50 = 0;
/* lp
	  //keys to repeat ?
	  event = keyrepeat();
	  if(event != 0)
	    {
	      if(!handleEvent(event))
		rootWindow_->handleEvent(event);
	
	      delete event;
	    }
lp */
 	}

      if(tick500 > 500)
	{
	  //emit timer signal with overrun time as paramter
	  timer500(tick500 - 500);
	  //reset counter
	  tick500 = 0;
	}

      if(tick100 > 100)
	{
	  //update mouse only when the windows has focus
	  if(focus_)
	  {
// lp	    mouse_->tick();
       }
	  //emit timer signal
	  emit timer100(tick100 - 100);
	  //reset
	  tick100 = 0;
	}

	// gather events into the event queue
    while((event = poll_events()) != 0)
    {
    	eventqueue->push_back(event);
    }
	
      //process SDL events
//lp      while(SDL_PollEvent(&sdl_event))
//bool cont = get_event(event);
	
//*	while(get_event(&event))
	while(!eventqueue->empty())
	{
	
		event = eventqueue->front();
		eventqueue->pop_front();
/* lp	
	  event = createUEvent(&sdl_event);

	  if(event->type() == CL_GEvent::KEY)
	    {
	      UKeyEvent* kevent = (UKeyEvent*)(event);

	      keyTable_[kevent->key()].sym = (SDLKey)(kevent->key());
	      keyTable_[kevent->key()].mod = (SDLMod)(kevent->modifier());
	      keyTable_[kevent->key()].unicode = kevent->unicode();
	    }
lp */
	  handled = false;
	
	  // do eventhandling in the application
	  handled = handleEvent(event);

	  //let GUI handle this event
 	  if(!handled)
 	    rootWindow_->handleEvent(event);
/* lp	
debugN(17,
	  //always handle "special keys" in debug mode
	  //no way to filter this
	  if(event->type() == CL_GEvent::KEY)
	    {
	      if(((UKeyEvent *)event)->key() == KEY_ESCAPE)
		{
		  handled = true;
		  running_ = false;
		  result = -1;
		}
	    }	
);
lp */	
	  delete event;	
	} // while(SDL_PollEvent()

      //derived classes go here
      result = eventloopProc();

      // no framebuffer update, when iconified
      if(!isIconified())
	{
/* lp	
	  // Mouse hide from framebuffer
	  if(focus_)
	    mouse_->remove();
*/	
	
	  //update the framebuffer
	  rootWindow_->update();
	
/* lp
	  // Mouse blit to framebuffer and update screen appropriately
	  // this is bad, because this screen area may gets
	  // update later again :-(
	  // hmmm, the question is whether this really is a performance hit
	  if(focus_)
	    mouse_->paint();
*/	
	
	  //blit framebuffer to screen
	  rootWindow_->updateScreen();
	}
    } // while(running_)

  return result;
}

CL_GEvent * CL_GApplication::poll_events()
{
	CL_System::keep_alive();
	
	curr_mouse_pos.x = CL_Mouse::get_x();
	curr_mouse_pos.y = CL_Mouse::get_y();
	bool left_pressed = CL_Mouse::left_pressed();
	bool middle_pressed = CL_Mouse::middle_pressed();
	bool right_pressed = CL_Mouse::right_pressed();
	int buttons, state;
	CL_GEvent *event=0;
	
	/* mouse move */
	if (!(curr_mouse_pos == prev_mouse_pos))
	{
		event = new CL_GMouseMotionEvent(curr_mouse_pos);
		prev_mouse_pos.x = curr_mouse_pos.x;
		prev_mouse_pos.y = curr_mouse_pos.y;
		return event;
	}

	/* keyboard */
	//CL_InputBuffer *keyboard = CL_Input::keyboards[0]->get_buffer(0);
	if (keyboard->keys_left())
	{
		event = new CL_GKeyEvent(keyboard->get_key());
		return event;
	}	
		
	/* left mouse button */
	if (prev_left_pressed != left_pressed)
	{
		buttons = CL_GMouseButtonEvent::BUTTON_LEFT;
		// left button was pressed or realesed
		if (left_pressed)
			state = CL_GMouseButtonEvent::PRESSED;
		else
			state = CL_GMouseButtonEvent::RELEASED;
			
		prev_left_pressed = left_pressed;
		event = new CL_GMouseButtonEvent(state, buttons, curr_mouse_pos);
		return event;		
	}
	
	/* right mouse button */
	if (prev_right_pressed != right_pressed)
	{
		buttons = CL_GMouseButtonEvent::BUTTON_RIGHT;
		// right button was pressed or realesed
		if (right_pressed)
			state = CL_GMouseButtonEvent::PRESSED;
		else
			state = CL_GMouseButtonEvent::RELEASED;
			
		prev_right_pressed = right_pressed;
		event = new CL_GMouseButtonEvent(state, buttons, curr_mouse_pos);
		return event;		
	}
	
	/* middle mouse button */
	if (prev_middle_pressed != middle_pressed)
	{
		buttons = CL_GMouseButtonEvent::BUTTON_MIDDLE;
		// middle button was pressed or realesed
		if (middle_pressed)
			state = CL_GMouseButtonEvent::PRESSED;
		else
			state = CL_GMouseButtonEvent::RELEASED;
			
		prev_middle_pressed = middle_pressed;
		event = new CL_GMouseButtonEvent(state, buttons, curr_mouse_pos);
		return event;		
	}		

	return event;
}


/*
bool CL_GApplication::get_event(CL_GEvent** event)
{
	curr_mouse_pos.x = CL_Mouse::get_x();
	curr_mouse_pos.y = CL_Mouse::get_y();
	bool left_pressed = CL_Mouse::left_pressed();
	bool middle_pressed = CL_Mouse::middle_pressed();
	bool right_pressed = CL_Mouse::right_pressed();
	int buttons, state;
	
	// mouse move
	if (!(curr_mouse_pos == prev_mouse_pos))
	{
		*event = new CL_GMouseMotionEvent(curr_mouse_pos);
		prev_mouse_pos.x = curr_mouse_pos.x;
		prev_mouse_pos.y = curr_mouse_pos.y;
		return true;
	}

	// keyboard
	CL_InputBuffer *keyboard = CL_Input::keyboards[0]->get_buffer(0);
	if (keyboard->keys_left())
	{
		*event = new CL_GKeyEvent(keyboard->get_key());
		return true;
	}	
		
	// left mouse button
	if (prev_left_pressed != left_pressed)
	{
		buttons = CL_GMouseButtonEvent::BUTTON_LEFT;
		// left button was pressed or realesed
		if (left_pressed)
			state = CL_GMouseButtonEvent::PRESSED;
		else
			state = CL_GMouseButtonEvent::RELEASED;
			
		prev_left_pressed = left_pressed;
		*event = new CL_GMouseButtonEvent(state, buttons, curr_mouse_pos);
		return true;		
	}
	
	// right mouse button
	if (prev_right_pressed != right_pressed)
	{
		buttons = CL_GMouseButtonEvent::BUTTON_RIGHT;
		// right button was pressed or realesed
		if (right_pressed)
			state = CL_GMouseButtonEvent::PRESSED;
		else
			state = CL_GMouseButtonEvent::RELEASED;
			
		prev_right_pressed = right_pressed;
		*event = new CL_GMouseButtonEvent(state, buttons, curr_mouse_pos);
		return true;		
	}
	
	// middle mouse button
	if (prev_middle_pressed != middle_pressed)
	{
		buttons = CL_GMouseButtonEvent::BUTTON_MIDDLE;
		// middle button was pressed or realesed
		if (middle_pressed)
			state = CL_GMouseButtonEvent::PRESSED;
		else
			state = CL_GMouseButtonEvent::RELEASED;
			
		prev_middle_pressed = middle_pressed;
		*event = new CL_GMouseButtonEvent(state, buttons, curr_mouse_pos);
		return true;		
	}		

	*event = 0;
	return false;
}
*/
//SLOT_IMPL(CL_GApplication, quit, int)
void CL_GApplication::quit(int n)
{

//lp  debugN(17,cerr << "CL_GApplication: was requested to quit." << endl;);
	TRACEMSG("CL_GApplication: was requested to quit");
  running_ = false;

}

//SLOT_IMPL(CL_GApplication, infoMsg, const char*)
void CL_GApplication::infoMsg(const char *data)
{
//lp  debugN(17,cerr << "CL_GApplication::Info: " << data << endl;);
  TRACEMSG("CL_GApplication::infoMsg: " << data);
}



















