/*
	$Id: cl_gbutton.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/
#include <API/GUI/cl_gbutton.h>
#include <API/GUI/cl_gapplication.h>

CL_GButton::CL_GButton(CL_GWidget *parent, int x, int y, int w, int h, int id) :
//	CL_GWidget(parent, x, y, w, h),
	CL_GLabel(parent, x, y, w, h),
	isPressed(false),
	id_(id)
{
	register_signal(cl_signal(CL_GButton::clicked));
	register_signal(cl_signal(CL_GButton::released));
	register_signal(cl_signal(CL_GButton::pressed));
	register_slot(cl_slot(CL_GButton::press));
	register_slot(cl_slot(CL_GButton::release));
	register_slot(cl_slot(CL_GButton::repeat));
}

CL_GButton::~CL_GButton()
{
	deregister_signal(cl_signal(CL_GButton::clicked));
	deregister_signal(cl_signal(CL_GButton::pressed));
	deregister_signal(cl_signal(CL_GButton::released));
	deregister_slot(cl_slot(CL_GButton::press));
	deregister_slot(cl_slot(CL_GButton::release));
	deregister_slot(cl_slot(CL_GButton::repeat));
}

void CL_GButton::set_repeat(bool repeat)
{
	if (!autoRepeat)
	{ 		// we were not connected or repeating
		if (repeat) // the connect
		{
			connect(uapp, cl_signal(CL_GApplication::timer500), this, cl_slot(CL_GButton::repeat));
			autoRepeat = true;		
		}
	}
	else //we were connected or repeating
	{
		if (!repeat) // then disconnect
		{
			disconnect(uapp, cl_signal(CL_GApplication::timer500), this, cl_slot(CL_GButton::repeat));
			autoRepeat = false;
		}                      	
	}                          		
}

void CL_GButton::press()
{
	if (isPressed)
		emit pressed(this);
	else
	{
		isPressed = true;
		// request screen update
		needsUpdate_ = true;
		
		emit pressed(this);		
	}
}

void CL_GButton::release()
{
	if (isPressed)
	{
		isPressed = false;
		// request screen update
		needsUpdate_ = true;
		emit released(this);
		emit clicked(this);		
	}
	else
		emit released(this);
}

void CL_GButton::repeat(int overrun)
{
	if (haveFocus_ && isPressed && autoRepeat)
	{
		emit clicked(this);
	}
}

bool CL_GButton::processEvent(const CL_GEvent *e)
{
	bool handled = false;

	if (haveFocus_)
	{
		if (e->type() == CL_GEvent::MOUSEBUTTON)
		{
			if ( ((CL_GMouseButtonEvent*)e)->buttons() == CL_GMouseButtonEvent::BUTTON_LEFT)
			{
				if ( ((CL_GMouseButtonEvent*)e)->state() == CL_GMouseButtonEvent::PRESSED)
				{
					isPressed = true;
					emit pressed(this);					
				}
				else if ( isPressed && (
					((CL_GMouseButtonEvent*)e)->state() == CL_GMouseButtonEvent::RELEASED))
				{
					isPressed = false;
					emit released(this);
					emit clicked(this);					
				}
				
				handled = true;
				needsUpdate_ = true;
			}
		}
	}

	if (isPressed && !haveFocus_)
	{
		isPressed = false;
		emit released(this);
		needsUpdate_= true;
	}
	
	return handled;
}












