/*
	$Id: cl_gtogglebutton.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
	
	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include <API/GUI/cl_gtogglebutton.h>

CL_GToggleButton::CL_GToggleButton(CL_GWidget *parent, int x, int y, int w, int h, int id=0) :
	CL_GPushButton(parent, x, y, w, h, id)
{}

CL_GToggleButton::~CL_GToggleButton()
{}

bool CL_GToggleButton::processEvent(const CL_GEvent *e)
{
	bool handled = false;
	
	if (haveFocus_)
	{
		if (e->type() == CL_GEvent::MOUSEBUTTON)
		{
			if ( (((CL_GMouseButtonEvent*)e)->buttons() == CL_GMouseButtonEvent::BUTTON_LEFT)
				&& (((CL_GMouseButtonEvent*)e)->state() == CL_GMouseButtonEvent::PRESSED) )
			{
				if (isPressed)
				{
					// the button _was_ pressed, now release it
					isPressed = false;
					emit released(this);
				}
				else
				{
					// the button _was_ released, now press it
					isPressed = true;
					emit pressed(this);
				}
			
				handled = true;
				needsUpdate_ = true;
			}
		}	
	}

	return handled;
}
	
void CL_GToggleButton::toggle(int toggle)
{
	if (isPressed)
	{
		isPressed = false;
		emit released(this);
	}
	else
	{
		isPressed = true;
		emit pressed(this);
	}

	needsUpdate_ = true;
}