/*
* Copyright (c) 2006 Rudi Cilibrasi, Rulers of the RHouse
* All rights reserved.     cilibrar@cilibrar.com
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of the RHouse nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS "AS IS" AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE RULERS AND CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __SPRINGBALL_H
#define __SPRINGBALL_H

extern "C" {
#include <qsearch/qsearch.h>
};
#include <ode/ode.h>
#include <timeframe.h>

/*! \file springball.h */

class PseudoSpring {
  dJointGroupID jg;
  dBodyID ss1, ss2;
  dJointID j1, j2, js;
  public:
  PseudoSpring(dWorldID w, dBodyID s1, dBodyID s2, dMass& msmall);
  ~PseudoSpring();
};

class SpringBallSystem {
  dWorldID _w;
  int _num_balls;
  dMass _ball_mass;
  dMass _shadowball_mass;
  dBodyID *_balls;
  double *_bpos;
  int _smatnum, _smatlast;
  gsl_matrix *_smattarget;
  bool _abort_now;
  bool _gravity_on;
  bool _motion_on;
  bool _coulomb_on;
  double _coulombic_power;
  const TimeFrame &_tf;
  PseudoSpring **_springs;
  pthread_mutex_t _balllock, _smatlock;
  void set_spring(int i, int j, PseudoSpring *s);
  PseudoSpring *get_spring(int i, int j) const;
  void adjust_spring_full(int i, int j, double sk);
  void add_coulombic(void);
  void add_gravity(void);
  public:
  SpringBallSystem(const TimeFrame &tf, int howManyBalls);
  ~SpringBallSystem(void);
  void get_ball_position(int whichBall, double *co);
  void set_ball_position(int whichBall, double *co);
  int get_ball_count(void) const;
  void adjust_to_springy_matrix(const gsl_matrix *mat);
  void dosimstep(void);
  void dosimloop(void);
  void dosimloopthread(void);
  void stopsimloop(void);
  void toggle_gravity(void);
  void toggle_coulombic(void);
  void toggle_motion(void);
  bool get_gravity(void) const;
  bool get_motion(void) const;
  bool is_spring_connecting(int i, int j) const;
  void getCOM(double m[3]);
  void adjustCOM(void);
};

#endif
