<?php
/**
 * Class to manage a dacode ldap users
 * ldap.inc - version 1.1
 *
 * Copyright (C) 1998  Eric Kilfoil eric@ipass.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The author can be reached at eric@ypass.net
 *
 * daCode http://www.dacode.org/
 * src/phplib/ldap.php3
 *
 * $Id: ldap.php3,v 1.7.2.5 2002/07/26 21:33:37 ruffy Exp $
 * Adapted by Pascal Pucci Pascal@deenoo.com for daCode
 * April 2001
 *
 * FIXME: cleanup necessary
 *
 *@author Eric Kilfoil <eric@ipass.net>
 */
class Ldap {
	var $hostname;
	var $basedn;
	var $binddn;
	var $bindpw;
	var $OCconfigFilePath;
	var $cid = 0; // LDAP Server Connection ID
	var $bid = 0; // LDAP Server Bind ID
	var $sr = 0; // Search Result
	var $re = 0; // Result Entry
	var $error = ""; // Any error messages to be returned can be put here
	var $start = 0; // 0 if we are fetching the first entry, otherwise 1
	var $objectClasses = array(); // Information read from slapd.oc.conf


	/**
	 * Class constructor
	 *@param string the dn for the bind (kind of username)
	 *@param string the passwd used for the bind
	 *@param string the hostname of the LDAP server
	 */
	function Ldap($binddn = "", $bindpw = "", $hostname = "")
	{
		global $config;

		$this->OCconfigFilePath = $config->ldap_sldapd_oc_conf_path;
		$this->basedn = $config->ldap_basedn;

		if (empty($binddn))
			$binddn = $config->ldap_binddn;
		if (empty($bindpw))
			$bindpw = $config->ldap_bindpw;
		if (empty($hostname))
			$hostname = $config->ldap_hostname;
		$this->connect($binddn, $bindpw, $hostname);
	}

	/**
	 * Reads the LDAP config (Objects definitions)?
	 * Parses the file and put it into objectClasses array.
	 * Calls echo to display an error message if unable to read file.
	 *@param string complete path to LDAP classes definitions.
	 *@access private
	 */
	function readConfiguration($OCconfigFilePath = "")
	{
		if (empty($OCconfigFilePath))
			$OCconfigFilePath = $this->OCconfigFilePath;

		if ($cf = fopen($OCconfigFilePath, "rb"))
		{
			$ctr = 0;
			while (! feof($cf))
			{
				$line = fgets($cf, 1024);
				// It's blank or ONLY a comment
				if ((chop($line) == "") || ereg("^[ \t]*#", $line, $regs))
					continue;
				if (eregi("[ \t]*objectclass[ \t]+([^#]+)", $line, $regs))
				{
					$oc[$ctr] = "";
					while (chop($line) != "" && ! feof($cf))
					{
						$oc[$ctr] .= $line;
						$line = fgets($cf, 10240);
					}
				}
				$ctr++;
			}
			for ($ctr = 0; $ctr < count($oc); $ctr++)
			{
				$ocdef = split("[ \n\t\r]", $oc[$ctr]);
				for ($intctr=0, $def = 0; $def < count($ocdef); $def++)
				{
					if (chop($ocdef[$def]) != "")
					{
						$intctr++;
						switch ($intctr)
						{
							case 1:
								if (strcasecmp($ocdef[$def], "objectclass"))
								{
									echo lecho("Error in objectclass ").$ocdef[1].
										lecho(". Expected ")."'objectclass'".lecho(", got ").
										"'".$ocdef[$def]."'<br />";
									exit();
								}
								break;
							case 2:
								$ocname = strtolower($ocdef[$def]);
								break;
							case 3:
								if (strcasecmp($ocdef[$def], "requires")
										&& strcasecmp($ocdef[$def], "allows"))
								{
									echo lecho("Error in objectclass ").$ocdef[1].
										lecho(". Expected ")."'requires'".lecho(" or ")."'allows'".
										lecho(", got ")."'".$ocdef[$def]."'<br />";
									exit();
								} else
									$curarray = $ocdef[$def];
								$occtr = 0;
								break;
							default:
								if (substr($ocdef[$def], strlen($ocdef[$def])-1, 1) == ",")
								{
									// it is _NOT_ the last entry
									$this->objectClasses[$ocname][$curarray][$occtr++] =
										strtolower(substr($ocdef[$def], 0,
										strlen($ocdef[$def])-1));
								} else {
									// it _IS_ the last entry
									$this->objectClasses[$ocname][$curarray][$occtr++] =
										strtolower($ocdef[$def]);
									$intctr = 2;
								}
								break;
						}
					}
				}
			}
		} else {
			$this->error = lecho("Could not open ").$OCconfigFilePath.
				lecho(" for read.");
			echo $this->error;
		}
	}

	/**
	 *Returns an array of classes.
	 * private? Not used anytwhere...
	 *@return array	
	 */
	function getObjectClasses()
	{
		if (count($this->objectClasses) == 0)
			$this->readConfiguration();

		$ocs = array();
		for ($ctr = 0, reset($this->objectClasses);
			$OCName = key($this->objectClasses); next($this->objectClasses), $ctr++)
			$ocs[$ctr] = $OCName;
		return($ocs);
	}

	/**
	 * Determines wether the object class has been defined in LDAP config
	 *@param string the name of the object class.
	 *@retrun boolean
	 *@access private
	 */
	function isObjectClass($ocname)
	{
		$ocname = strtolower($ocname);

		if (count($this->objectClasses) == 0)
			$this->readConfiguration();

		if (is_array($this->objectClasses[$ocname]))
			return(1);
		return(0);
	}

	/**
	 * Gets some properties of object class
	 * FIXME: Not used anywhere?
	 *@param string the name of the obj. class
	 *@return array the property
	 *@access private
	 */
	function getAllows($ocname)
	{
		$ocname = strtolower($ocname);

		if (count($this->objectClasses) == 0)
			$this->readConfiguration();

		if (! $this->isObjectClass($ocname))
			return(array());

		$allows = array();
		$allows = $this->objectClasses[$ocname]["allows"];
		return($allows);
	}

	/**
	 * Gets some properties of object class
	 * FIXME: not used anywhere
	 *@param string the name of the obj. class
	 *@return array the property
	 *@access private
	 */
	function getRequires($ocname)
	{
		$ocname = strtolower($ocname);

		if (count($this->objectClasses) == 0)
			$this->readConfiguration();

		if (! $this->isObjectClass($ocname))
			return(array());

		$requires = array();
		$requires = $this->objectClasses[$ocname]["requires"];
		return($requires);
	}

	/**
	 * Gets some properties of object class, never used
	 *@param string the name of the obj. class
	 *@param string ????
	 *@return boolean the property
	 *@access private
	 *@todo FIXME!!!!
	 */
	function isAllowed($ocname, $allowed)
	{
		$ocname = strtolower($ocname);
		$allowed = strtolower($allowed);

		if (count($this->objectClasses) == 0)
			$this->readConfiguration();

		if (! $this->isObjectClass($ocname))
			return(0);

		for ($ctr = 0; $ctr < count($this->objectClasses[$ocname]["allows"]);
					$ctr++)
			if (strcasecmp($this->objectClasses[$ocname]["allows"][$ctr],
					$allowed) == 0)
				return(1);

		return(0);
	}


	/**
	 * Gets some properties of object class, never used
	 *@param string the name of the obj. class
	 *@param string ????
	 *@return array the property
	 *@todo FIXME!!!!
	 *@access private
	 */
	function isRequired($ocname, $required)
	{
		$ocname = strtolower($ocname);
		$required = strtolower($required);

		if (count($this->objectClasses) == 0)
			$this->readConfiguration();

		if (! $this->isObjectClass($ocname))
			return(0);

		for ($ctr = 0; $ctr < count($this->objectClasses[$ocname]["requires"]);
					$ctr++)
			if (strcasecmp($this->objectClasses[$ocname]["requires"][$ctr],
					$required) == 0)
				return(1);

		return(0);
	}

	/**
	 * Sets hostname of LDAP server, never used
	 *@param string
	 *@access public
	 */
	function setLDAPHost($hostname)
	{
		$this->hostname = $hostname;
	}

	/**
	 * Returns hostname of LDAP server, never used
	 *@param string in an accessor?????
	 *@return string
	 *@access public
	 */
	function getLDAPHost($hostname)
	{
		return($this->hostname);
	}

	/**
	 * sets distinguished name for the bind
	 *@param string
	 *@access public
	 */
	function setBindDN($binddn)
	{
		$this->binddn = $binddn;
	}

	/**
	 * Returns distinguished name for the bind
	 *@param string in an accessor?????
	 *@return string
	 *@access public
	 */
	function getBindDN($binddn)
	{
		return($this->binddn);
	}

	/**
	 * Sets base distinguished name
	 *@param string
	 *@access public
	 */
	function setBaseDN($basedn)
	{
		$this->basedn = $basedn;
	}

	/**
	 * Returns base distinguished name
	 *@param string in an accessor?????
	 *@return string
	 *@access public
	 */
	function getBaseDN($basedn)
	{
		return($this->basedn);
	}

	/**
	 * Sets bind password
	 *@param string
	 *@access public
	 */
	function setBindPassword($bindpw)
	{
		$this->bindpw = $bindpw;
	}

	/**
	 * Returns bind password
	 *@param string in an accessor?????
	 *@return string
	 *@access public
	 */
	function getBindPassword($bindpw)
	{
		return($this->bindpw);
	}


	/**
	 * Sets current directory to $dir
	 *@param string
	 *@access public
	 */
	function cd($dir)
	{
		if ($dir == "..")
			$this->basedn = $this->getParentDir();
		else
			$this->basedn = $dir;
	}

	/**
	 * Returns the name of the parent level in LDAP hierarchy.
	 *@param string dn to compute parent.
	 *@return string
	 *@access public
	 */
	function getParentDir($basedn = "")
	{
		if (!$basedn)
			$basedn = $this->basedn;
		if ($this->basedn == LDAP_BASEDN)
			return("");
		return(ereg_replace("[^,]*[,]*[ ]*(.*)", "\\1", $basedn));
	}


	/**
	 * Conects to the LDAP server
	 * Calss echo if fails.
	 *@param string distinguished name for the bind
	 *@param string bind password
	 *@param string hostname of LDAP server
	 *@return integer a bind ID on success, an error code on failure.
	 *@access private
	 */
	function connect($binddn, $bindpw, $hostname)
	{
		$e = error_reporting(0);
		if (! $this->cid)
		{
			if ($this->cid=ldap_connect($hostname)) {
				$this->error = lecho("No Error");
				if ($this->bid = ldap_bind($this->cid, $binddn, $bindpw)) {
					$this->error = lecho("Success");
					error_reporting($e);
					return($this->bid);
				} else {
					$this->error = lecho("Could not bind to ") . $binddn;
					error_reporting($e);
					return($this->bid);
				}
			} else {
				$this->error = lecho("Could not connect to LDAP server");
				error_reporting($e);
				return($this->cid);
			}
		} else {
			error_reporting($e);
			return($this->cid);
		}
	}

	/**
	 * Closes the connexion to the LDAP server, never used?!
	 *@access public
	 */
	function disconnect()
	{
		ldap_close($this->cid);
	}

	/**
	 * Performs a search in the directory.
	 * This is quite poorly written...
	 *@param string the filter for the search
	 *@return integer a search result identifier or 0 on failure.
	 *@access public
	 */
	function search($filter)
	{
		$e = error_reporting(0);
		$result = array();
		if (!$this->connect())
		{
			error_reporting($e);
			return(0);
		}

		$this->sr = ldap_search($this->cid, $this->basedn, $filter);
		$ldap->error = ldap_error($this->cid);
		$this->resetResult();
		error_reporting($e);
		return($this->sr);
	}

	/**
	 * Lists all objects at the current level of LDAP hierarchy., never used
	 *@param string the filter for the search
	 *@param string the base dn to use, if not the current one.
	 *@access public
	 */
	function ls($filter = "(objectclass=*)", $basedn = "")
	{
		if (empty($basedn))
			$basedn = $this->basedn;
		if (empty($filter))
			$filter = "(objectclass=*)";

		$e = error_reporting(0);
		$result = array();
		if (!$this->connect())
		{
			error_reporting($e);
			return(0);
		}

		$this->sr = ldap_list($this->cid, $basedn, $filter);
		$ldap->error = ldap_error($this->cid);
		$this->resetResult();
		error_reporting($e);
		return($this->sr);
	}

	/**
	 * Read an entry in the directory, never used
	 *@param string the dn of the object
	 *@return integer a search result identifier or 0 on error.
	 *@access public
	 */
	function cat($dn)
	{
		$e = error_reporting(0);
		$result = array();
		if (!$this->connect())
		{
			error_reporting($e);
			return(0);
		}
		$filter = "(objectclass=*)";

		$this->sr = ldap_read($this->cid, $dn, $filter);
		$ldap->error = ldap_error($this->cid);
		$this->resetResult();
		error_reporting($e);
		return($this->sr);
	}

	/**
	 * Fetches an entry in the current result set.
	 *@return array the attributes of the entry
	 *@access public
	 */
	function fetch()
	{
		$e = error_reporting(0);
		if ($this->start == 0)
		{
			$this->start = 1;
			$this->re = ldap_first_entry($this->cid, $this->sr);
		} else {
			$this->re = ldap_next_entry($this->cid, $this->re);
		}
		if ($this->re)
		{
			$att = ldap_get_attributes($this->cid, $this->re);
		}
		$ldap->error = ldap_error($this->cid);
		error_reporting($e);
		return($att);
	}

	/**
	 * resets the array of results
	 *@access public
	 */
	function resetResult()
	{
		$this->start = 0;
	}

	/**
	 * Gets dn of current result entry
	 *@return string 
	 *@access public
	 */
	function getDN()
	{
		$e = error_reporting(0);
		$rv = ldap_get_dn($this->cid, $this->re);
		$ldap->error = ldap_error($this->cid);
		error_reporting($e);
		return($rv);
	}

	/**
	 * Counts the number of entries in result set
	 *@access public
	 */
	function count()
	{
		$e = error_reporting(0);
		$rv = ldap_count_entries($this->cid, $this->sr);
		$ldap->error = ldap_error($this->cid);
		error_reporting($e);
		return($rv);
	}

	/**
	 * Add a new entry in directory of objectClass top
	 *@param string Name of the attribute (for the DN)
	 *@param string Name of the entry (for the DN)
	 *@param string Dn where to add entry
	 *@return boolean true on success
	 *@access public
	 */
	function mkdir($attrname, $dirname, $basedn = "")
	{
		if (empty($basedn))
			$basedn = $this->basedn;
		$e = error_reporting(0);
		$info["objectclass"] = "top";
		//$info[$attrname] = $dirname;
		$r = ldap_add($this->cid, "$attrname=$dirname, " . $basedn, $info);
		$ldap->error = ldap_error($this->cid);
		error_reporting($e);
		return($r ? $r : 0);
	}

	/**
	 * Deletes attributes of entry 
	 *@param mixed array or empty string 
	 *@param string the entry (default: current entry)
	 *@return boolean true on success
	 *@access public-
	 */
	function rm($attrs = "", $dn = "")
	{
		if (empty($dn))
			$dn = $this->basedn;

		$e = error_reporting(0);
		$r = ldap_mod_del($this->cid, $dn, $attrs);
		$ldap->error = ldap_error($this->cid);
		error_reporting($e);
		return($r);
	}

	/**
	 * Replaces attributes for specified DN
	 * Wrapper for ldap_mod_replace
	 *@param array the arrtibutes to set
	 *@param string the dn; current one if empty.
	 *@return boolean true on success
	 *@access public
	 */
	function rename($attrs, $dn = "")
	{
		if (empty($dn))
			$dn = $this->basedn;

		$e = error_reporting(0);
		$r = ldap_mod_replace($this->cid, $dn, $attrs);
		$ldap->error = ldap_error($this->cid);
		error_reporting($e);
		return($r);
	}

	/**
	 * Deletes an entry form directory
	 *@param string DN to delete. NO DEFAULT
	 *@return boolean true on success
	 *@access public
	 */
	function rmdir($deletedn)
	{
		$e = error_reporting(0);
		$r = ldap_delete($this->cid, $deletedn);
		$this->error = ldap_error($this->cid);
		error_reporting($e);
		return($r ? $r : 0);
	}

	/**
	 * Modifies the current entry
	 *@param string
	 *@return boolean true on success
	 *@access public
	 */
	function modify($attrs)
	{
		$e = error_reporting(0);
		$r = ldap_modify($this->cid, $this->basedn, $attrs);
		$this->error = ldap_error($this->cid);
		error_reporting($e);
		return($r ? $r : 0);
	}
}
?>
