#!/usr/bin/env perl

# A test for pulling a patch to remove a directory when the local copy is not empty.
# Issue154

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;
use File::Slurp;

init_tmp_repo();

mkdir 'd';
darcs 'add d';
darcs 'record -a -m "Added directory d"';

darcs 'get ./ puller';
chdir 'puller';
touch 'd/moo';
darcs 'add d/moo';
chdir '../';

rm_rf 'd';
darcs 'record -a -m "Remove directory d"';
ok( (chdir 'puller'), "chdir puller");
my $out = echo_to_darcs "pull -a ../", 'y';
like($out, qr{
             backing\sup
             .*
             finished\spulling
             }imsx
    , "result is that locally directory gets backed up and pull succeeds");



