using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Db4objects.Db4o;

namespace Db4objects.Db4odoc.Binding
{
	/// <summary>
	/// Summary description for CustomerForm.
	/// </summary>
	public class CustomerForm : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.TextBox _txtPhoneNumber;
		internal System.Windows.Forms.ComboBox _cmbCustomers;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
        
		internal System.Windows.Forms.Label _labelPhone;
		internal System.Windows.Forms.Label _labelName;

		private IObjectContainer _container = null;

		private ArrayList _customers = new ArrayList();

		public CustomerForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			OpenDataFile();
			SetUpDataBindings();
		}

		void OpenDataFile()
		{
			string dataFile = Path.Combine(Application.UserAppDataPath, "data.yap");
			_container = Db4oFactory.OpenFile(dataFile);
		}

		void SetUpDataBindings()
		{
			ObjectSet os = _container.Get(typeof(Customer));
			if (0 == os.Size())
			{
				// Generate some initial data
				_customers.Add(new Customer("John Cleese", "55-98763333"));
				_customers.Add(new Customer("Herman Hesse","32-33335555"));
				_customers.Add(new Customer("Douglas Adams", "42-42424242"));
			}
			else
			{
				while (os.HasNext())
				{
					_customers.Add(os.Next());
				}
			}
			_cmbCustomers.DisplayMember = "Name";
			_cmbCustomers.DataSource = _customers;
			_txtPhoneNumber.DataBindings.Add("Text", _customers, "PhoneNumber");
		}

		void PersistChanges()
		{
			foreach (Customer customer in _customers)
			{
				_container.Set(customer);
			}
		}

		protected override void OnClosing(CancelEventArgs e)
		{
			PersistChanges();
			_container.Close();
			base.OnClosing (e);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this._labelPhone = new System.Windows.Forms.Label();
			this._txtPhoneNumber = new System.Windows.Forms.TextBox();
			this._labelName = new System.Windows.Forms.Label();
			this._cmbCustomers = new System.Windows.Forms.ComboBox();
			this.SuspendLayout();
			// 
			// _labelPhone
			// 
			this._labelPhone.Location = new System.Drawing.Point(8, 48);
			this._labelPhone.Name = "_labelPhone";
			this._labelPhone.Size = new System.Drawing.Size(72, 16);
			this._labelPhone.TabIndex = 9;
			this._labelPhone.Text = "Phone#:";
			// 
			// _txtPhoneNumber
			// 
			this._txtPhoneNumber.Location = new System.Drawing.Point(96, 48);
			this._txtPhoneNumber.Name = "_txtPhoneNumber";
			this._txtPhoneNumber.Size = new System.Drawing.Size(184, 20);
			this._txtPhoneNumber.TabIndex = 8;
			this._txtPhoneNumber.Text = "";
			// 
			// _labelName
			// 
			this._labelName.Location = new System.Drawing.Point(8, 16);
			this._labelName.Name = "_labelName";
			this._labelName.Size = new System.Drawing.Size(72, 16);
			this._labelName.TabIndex = 7;
			this._labelName.Text = "Customer:";
			// 
			// _cmbCustomers
			// 
			this._cmbCustomers.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this._cmbCustomers.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this._cmbCustomers.Location = new System.Drawing.Point(96, 16);
			this._cmbCustomers.Name = "_cmbCustomers";
			this._cmbCustomers.Size = new System.Drawing.Size(186, 21);
			this._cmbCustomers.TabIndex = 6;
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(290, 79);
			this.Controls.Add(this._labelPhone);
			this.Controls.Add(this._txtPhoneNumber);
			this.Controls.Add(this._labelName);
			this.Controls.Add(this._cmbCustomers);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Name = "MainForm";
			this.Text = "Db4o Data Binding";
			this.ResumeLayout(false);

		}
		#endregion
	}
}
