/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit.Extensions
{
	public class AbstractDb4oTestCase : Db4oUnit.Extensions.IDb4oTestCase
	{
		[System.NonSerialized]
		private Db4oUnit.Extensions.IDb4oFixture _fixture;

		public virtual void Fixture(Db4oUnit.Extensions.IDb4oFixture fixture)
		{
			_fixture = fixture;
		}

		public virtual Db4oUnit.Extensions.IDb4oFixture Fixture()
		{
			return _fixture;
		}

		public virtual bool IsClientServer()
		{
			return Fixture() is Db4oUnit.Extensions.Fixtures.AbstractClientServerDb4oFixture;
		}

		protected virtual void Reopen()
		{
			_fixture.Reopen();
		}

		public void SetUp()
		{
			_fixture.Clean();
			Configure(_fixture.Config());
			_fixture.Open();
			Db4oSetupBeforeStore();
			Store();
			_fixture.Db().Commit();
			_fixture.Close();
			_fixture.Open();
			Db4oSetupAfterStore();
		}

		public void TearDown()
		{
			Db4oCustomTearDown();
			_fixture.Close();
			_fixture.Clean();
		}

		protected virtual void Db4oSetupBeforeStore()
		{
		}

		protected virtual void Db4oSetupAfterStore()
		{
		}

		protected virtual void Db4oCustomTearDown()
		{
		}

		protected virtual void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
		}

		protected virtual void Store()
		{
		}

		public virtual Db4objects.Db4o.Ext.IExtObjectContainer Db()
		{
			return Fixture().Db();
		}

		protected virtual System.Type[] TestCases()
		{
			return new System.Type[] { GetType() };
		}

		public virtual int RunSoloAndClientServer()
		{
			return RunSoloAndClientServer(true);
		}

		private int RunSoloAndClientServer(bool independentConfig)
		{
			return new Db4oUnit.TestRunner(new Db4oUnit.TestSuite(new Db4oUnit.ITest[] { SoloSuite
				(independentConfig).Build(), ClientServerSuite(independentConfig).Build() })).Run
				();
		}

		public virtual int RunSolo()
		{
			return RunSolo(true);
		}

		public virtual int RunSolo(bool independentConfig)
		{
			return new Db4oUnit.TestRunner(SoloSuite(independentConfig)).Run();
		}

		public virtual int RunClientServer()
		{
			return RunClientServer(true);
		}

		public virtual int RunEmbeddedClientServer()
		{
			return RunEmbeddedClientServer(true);
		}

		private int RunEmbeddedClientServer(bool independentConfig)
		{
			return new Db4oUnit.TestRunner(EmbeddedClientServerSuite(independentConfig)).Run(
				);
		}

		public virtual int RunClientServer(bool independentConfig)
		{
			return new Db4oUnit.TestRunner(ClientServerSuite(independentConfig)).Run();
		}

		private Db4oUnit.Extensions.Db4oTestSuiteBuilder SoloSuite(bool independentConfig
			)
		{
			return new Db4oUnit.Extensions.Db4oTestSuiteBuilder(new Db4oUnit.Extensions.Fixtures.Db4oSolo
				(ConfigSource(independentConfig)), TestCases());
		}

		private Db4oUnit.Extensions.Db4oTestSuiteBuilder ClientServerSuite(bool independentConfig
			)
		{
			return new Db4oUnit.Extensions.Db4oTestSuiteBuilder(new Db4oUnit.Extensions.Fixtures.Db4oSingleClient
				(ConfigSource(independentConfig)), TestCases());
		}

		private Db4oUnit.Extensions.Db4oTestSuiteBuilder EmbeddedClientServerSuite(bool independentConfig
			)
		{
			return new Db4oUnit.Extensions.Db4oTestSuiteBuilder(new Db4oUnit.Extensions.Fixtures.Db4oSingleClient
				(ConfigSource(independentConfig), 0), TestCases());
		}

		private Db4oUnit.Extensions.Fixtures.IConfigurationSource ConfigSource(bool independentConfig
			)
		{
			return (independentConfig ? (Db4oUnit.Extensions.Fixtures.IConfigurationSource)new 
				Db4oUnit.Extensions.Fixtures.IndependentConfigurationSource() : new Db4oUnit.Extensions.Fixtures.GlobalConfigurationSource
				());
		}

		protected virtual Db4objects.Db4o.Internal.ObjectContainerBase Stream()
		{
			return (Db4objects.Db4o.Internal.ObjectContainerBase)Db();
		}

		public virtual Db4objects.Db4o.Internal.LocalObjectContainer FileSession()
		{
			return Fixture().FileSession();
		}

		protected virtual Db4objects.Db4o.Internal.Transaction Trans()
		{
			return Stream().GetTransaction();
		}

		protected virtual Db4objects.Db4o.Internal.Transaction SystemTrans()
		{
			return Stream().GetSystemTransaction();
		}

		protected virtual Db4objects.Db4o.Query.IQuery NewQuery(Db4objects.Db4o.Internal.Transaction
			 transaction, System.Type clazz)
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery(transaction);
			query.Constrain(clazz);
			return query;
		}

		protected virtual Db4objects.Db4o.Query.IQuery NewQuery(Db4objects.Db4o.Internal.Transaction
			 transaction)
		{
			return Stream().Query(transaction);
		}

		protected virtual Db4objects.Db4o.Query.IQuery NewQuery()
		{
			return Db().Query();
		}

		protected virtual Db4objects.Db4o.Reflect.IReflector Reflector()
		{
			return Stream().Reflector();
		}

		protected virtual void IndexField(Db4objects.Db4o.Config.IConfiguration config, System.Type
			 clazz, string fieldName)
		{
			config.ObjectClass(clazz).ObjectField(fieldName).Indexed(true);
		}

		protected virtual Db4objects.Db4o.Internal.Transaction NewTransaction()
		{
			return Stream().NewTransaction();
		}

		protected virtual Db4objects.Db4o.Query.IQuery NewQuery(System.Type clazz)
		{
			Db4objects.Db4o.Query.IQuery query = NewQuery();
			query.Constrain(clazz);
			return query;
		}

		protected virtual object RetrieveOnlyInstance(System.Type clazz)
		{
			Db4objects.Db4o.IObjectSet result = NewQuery(clazz).Execute();
			Db4oUnit.Assert.AreEqual(1, result.Size());
			return result.Next();
		}

		protected virtual int CountOccurences(System.Type clazz)
		{
			Db4objects.Db4o.IObjectSet result = NewQuery(clazz).Execute();
			return result.Size();
		}

		protected virtual void Foreach(System.Type clazz, Db4objects.Db4o.Foundation.IVisitor4
			 visitor)
		{
			Db4objects.Db4o.Ext.IExtObjectContainer oc = Db();
			oc.Deactivate(clazz, int.MaxValue);
			Db4objects.Db4o.IObjectSet set = NewQuery(clazz).Execute();
			while (set.HasNext())
			{
				visitor.Visit(set.Next());
			}
		}

		protected virtual void DeleteAll(System.Type clazz)
		{
			Foreach(clazz, new _AnonymousInnerClass206(this));
		}

		private sealed class _AnonymousInnerClass206 : Db4objects.Db4o.Foundation.IVisitor4
		{
			public _AnonymousInnerClass206(AbstractDb4oTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Visit(object obj)
			{
				this._enclosing.Db().Delete(obj);
			}

			private readonly AbstractDb4oTestCase _enclosing;
		}

		protected void Store(object obj)
		{
			Db().Set(obj);
		}

		protected virtual Db4objects.Db4o.Reflect.IReflectClass ReflectClass(System.Type 
			clazz)
		{
			return Reflector().ForClass(clazz);
		}

		protected virtual void Defragment()
		{
			Fixture().Close();
			Fixture().Defragment();
			Fixture().Open();
		}
	}
}
