/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit
{
	public class TestRunner
	{
		private Db4oUnit.ITestSuiteBuilder _suiteBuilder;

		public TestRunner(Db4oUnit.TestSuite suite)
		{
			if (null == suite)
			{
				throw new System.ArgumentException("suite");
			}
			_suiteBuilder = new Db4oUnit.NullTestSuiteBuilder(suite);
		}

		public TestRunner(Db4oUnit.ITestSuiteBuilder builder)
		{
			if (null == builder)
			{
				throw new System.ArgumentException("suite");
			}
			_suiteBuilder = builder;
		}

		public TestRunner(System.Type clazz) : this(new Db4oUnit.ReflectionTestSuiteBuilder
			(clazz))
		{
		}

		public virtual int Run()
		{
			return Run(true);
		}

		private int Run(bool printLabels)
		{
			Db4oUnit.TestSuite suite = BuildTestSuite();
			if (null == suite)
			{
				return 1;
			}
			Db4oUnit.TestResult result = new Db4oUnit.TestResult(printLabels);
			result.RunStarted();
			suite.Run(result);
			result.RunFinished();
			Report(result);
			return result.Failures().Size();
		}

		private Db4oUnit.TestSuite BuildTestSuite()
		{
			try
			{
				return _suiteBuilder.Build();
			}
			catch (System.Exception x)
			{
				Report(x);
			}
			return null;
		}

		private void Report(System.Exception x)
		{
			System.IO.TextWriter stdout = Db4oUnit.TestPlatform.GetStdOut();
			Db4oUnit.TestPlatform.PrintStackTrace(stdout, x);
		}

		private void Report(Db4oUnit.TestResult result)
		{
			try
			{
				System.IO.TextWriter stdout = Db4oUnit.TestPlatform.GetStdOut();
				result.Print(stdout);
				stdout.Flush();
			}
			catch (System.IO.IOException)
			{
			}
		}
	}
}
