/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class ClassMetadataTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class SuperClazz
		{
			public int _id;

			public string _name;
		}

		public class SubClazz : Db4objects.Db4o.Tests.Common.Assorted.ClassMetadataTestCase.SuperClazz
		{
			public int _age;
		}

		protected override void Store()
		{
			Store(new Db4objects.Db4o.Tests.Common.Assorted.ClassMetadataTestCase.SubClazz());
		}

		public virtual void TestFieldIterator()
		{
			Db4objects.Db4o.Foundation.Collection4 expectedNames = new Db4objects.Db4o.Foundation.Collection4
				(new Db4objects.Db4o.Foundation.ArrayIterator4(new string[] { "_id", "_name", "_age"
				 }));
			Db4objects.Db4o.Internal.ClassMetadata clazz = Stream().GetYapClass(Reflector().ForClass
				(typeof(Db4objects.Db4o.Tests.Common.Assorted.ClassMetadataTestCase.SubClazz)));
			System.Collections.IEnumerator fieldIter = clazz.Fields();
			while (fieldIter.MoveNext())
			{
				Db4objects.Db4o.Internal.FieldMetadata curField = (Db4objects.Db4o.Internal.FieldMetadata
					)fieldIter.Current;
				Db4oUnit.Assert.IsNotNull(expectedNames.Remove(curField.GetName()));
			}
			Db4oUnit.Assert.IsTrue(expectedNames.IsEmpty());
		}
	}
}
