/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Querying
{
	public class CascadeDeleteArray : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class ArrayElem
		{
			public string name;

			public ArrayElem(string name)
			{
				this.name = name;
			}
		}

		public Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem[] array;

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			config.ObjectClass(this).CascadeOnDelete(true);
		}

		protected override void Store()
		{
			Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray cda = new Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray
				();
			cda.array = new Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem
				[] { new Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem("one"
				), new Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem("two")
				, new Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem("three"
				) };
			Db().Set(cda);
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray cda = (Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray
				)RetrieveOnlyInstance(GetType());
			Db4oUnit.Assert.AreEqual(3, CountOccurences(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem)
				));
			Db().Delete(cda);
			Db4oUnit.Assert.AreEqual(0, CountOccurences(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem)
				));
			Db().Rollback();
			Db4oUnit.Assert.AreEqual(3, CountOccurences(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem)
				));
			Db().Delete(cda);
			Db4oUnit.Assert.AreEqual(0, CountOccurences(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem)
				));
			Db().Commit();
			Db4oUnit.Assert.AreEqual(0, CountOccurences(typeof(Db4objects.Db4o.Tests.Common.Querying.CascadeDeleteArray.ArrayElem)
				));
		}
	}
}
