/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Staging
{
	public class ObjectVersionTest : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public static void Main(string[] arguments)
		{
			new Db4objects.Db4o.Tests.Common.Staging.ObjectVersionTest().RunClientServer();
		}

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			config.GenerateUUIDs(int.MaxValue);
			config.GenerateVersionNumbers(int.MaxValue);
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Ext.IExtObjectContainer oc = this.Db();
			Db4objects.Db4o.Tests.Common.Assorted.SimplestPossibleItem @object = new Db4objects.Db4o.Tests.Common.Assorted.SimplestPossibleItem
				("c1");
			oc.Set(@object);
			Db4objects.Db4o.Ext.IObjectInfo objectInfo1 = oc.GetObjectInfo(@object);
			long oldVer = objectInfo1.GetVersion();
			@object.SetName("c3");
			oc.Set(@object);
			Db4objects.Db4o.Ext.IObjectInfo objectInfo2 = oc.GetObjectInfo(@object);
			long newVer = objectInfo2.GetVersion();
			Db4oUnit.Assert.IsNotNull(objectInfo1.GetUUID());
			Db4oUnit.Assert.IsNotNull(objectInfo2.GetUUID());
			Db4oUnit.Assert.IsTrue(oldVer > 0);
			Db4oUnit.Assert.IsTrue(newVer > 0);
			Db4oUnit.Assert.AreEqual(objectInfo1.GetUUID(), objectInfo2.GetUUID());
			Db4oUnit.Assert.IsTrue(newVer > oldVer);
		}
	}
}
