/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal
{
	/// <exclude></exclude>
	public class LatinStringIO
	{
		protected char[] chars = new char[0];

		public virtual int BytesPerChar()
		{
			return 1;
		}

		public virtual byte EncodingByte()
		{
			return Db4objects.Db4o.Internal.Const4.ISO8859;
		}

		internal static Db4objects.Db4o.Internal.LatinStringIO ForEncoding(byte encodingByte
			)
		{
			switch (encodingByte)
			{
				case Db4objects.Db4o.Internal.Const4.ISO8859:
				{
					return new Db4objects.Db4o.Internal.LatinStringIO();
				}

				default:
				{
					return new Db4objects.Db4o.Internal.UnicodeStringIO();
					break;
				}
			}
		}

		public virtual int Length(string a_string)
		{
			return a_string.Length + Db4objects.Db4o.Internal.Const4.OBJECT_LENGTH + Db4objects.Db4o.Internal.Const4
				.INT_LENGTH;
		}

		protected virtual void CheckBufferLength(int a_length)
		{
			if (a_length > chars.Length)
			{
				chars = new char[a_length];
			}
		}

		public virtual string Read(Db4objects.Db4o.Internal.Buffer bytes, int a_length)
		{
			CheckBufferLength(a_length);
			for (int ii = 0; ii < a_length; ii++)
			{
				chars[ii] = (char)(bytes._buffer[bytes._offset++] & unchecked((int)(0xff)));
			}
			return new string(chars, 0, a_length);
		}

		public virtual string Read(byte[] a_bytes)
		{
			CheckBufferLength(a_bytes.Length);
			for (int i = 0; i < a_bytes.Length; i++)
			{
				chars[i] = (char)(a_bytes[i] & unchecked((int)(0xff)));
			}
			return new string(chars, 0, a_bytes.Length);
		}

		public virtual int ShortLength(string a_string)
		{
			return a_string.Length + Db4objects.Db4o.Internal.Const4.INT_LENGTH;
		}

		protected virtual int WritetoBuffer(string str)
		{
			int len = str.Length;
			CheckBufferLength(len);
			Sharpen.Runtime.GetCharsForString(str, 0, len, chars, 0);
			return len;
		}

		public virtual void Write(Db4objects.Db4o.Internal.Buffer bytes, string @string)
		{
			int len = WritetoBuffer(@string);
			for (int i = 0; i < len; i++)
			{
				bytes._buffer[bytes._offset++] = (byte)(chars[i] & unchecked((int)(0xff)));
			}
		}

		internal virtual byte[] Write(string @string)
		{
			int len = WritetoBuffer(@string);
			byte[] bytes = new byte[len];
			for (int i = 0; i < len; i++)
			{
				bytes[i] = (byte)(chars[i] & unchecked((int)(0xff)));
			}
			return bytes;
		}
	}
}
