/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Nativequery.Expr.Cmp
{
	public sealed class ComparisonOperator
	{
		public const int EQUALS_ID = 0;

		public const int SMALLER_ID = 1;

		public const int GREATER_ID = 2;

		public const int CONTAINS_ID = 3;

		public const int STARTSWITH_ID = 4;

		public const int ENDSWITH_ID = 5;

		public const int IDENTITY_ID = 6;

		public static readonly Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator EQUALS
			 = new Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator(EQUALS_ID, "==", 
			true);

		public static readonly Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator SMALLER
			 = new Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator(SMALLER_ID, "<", 
			false);

		public static readonly Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator GREATER
			 = new Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator(GREATER_ID, ">", 
			false);

		public static readonly Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator CONTAINS
			 = new Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator(CONTAINS_ID, "<CONTAINS>"
			, false);

		public static readonly Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator STARTSWITH
			 = new Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator(STARTSWITH_ID, "<STARTSWITH>"
			, false);

		public static readonly Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator ENDSWITH
			 = new Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator(ENDSWITH_ID, "<ENDSWITH>"
			, false);

		public static readonly Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator IDENTITY
			 = new Db4objects.Db4o.Nativequery.Expr.Cmp.ComparisonOperator(IDENTITY_ID, "==="
			, true);

		private int _id;

		private string _op;

		private bool _symmetric;

		private ComparisonOperator(int id, string op, bool symmetric)
		{
			_id = id;
			_op = op;
			_symmetric = symmetric;
		}

		public int Id()
		{
			return _id;
		}

		public override string ToString()
		{
			return _op;
		}

		public bool IsSymmetric()
		{
			return _symmetric;
		}
	}
}
