/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Nativequery.Expr
{
	public class TraversingExpressionVisitor : Db4objects.Db4o.Nativequery.Expr.IExpressionVisitor
		, Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperandVisitor
	{
		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.AndExpression expression
			)
		{
			expression.Left().Accept(this);
			expression.Right().Accept(this);
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.BoolConstExpression expression
			)
		{
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.OrExpression expression
			)
		{
			expression.Left().Accept(this);
			expression.Right().Accept(this);
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.ComparisonExpression expression
			)
		{
			expression.Left().Accept(this);
			expression.Right().Accept(this);
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.NotExpression expression
			)
		{
			expression.Expr().Accept(this);
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.ArithmeticExpression
			 operand)
		{
			operand.Left().Accept(this);
			operand.Right().Accept(this);
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.ConstValue operand
			)
		{
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.FieldValue operand
			)
		{
			operand.Parent().Accept(this);
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.Field.CandidateFieldRoot
			 root)
		{
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.Field.PredicateFieldRoot
			 root)
		{
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.Field.StaticFieldRoot
			 root)
		{
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.ArrayAccessValue operand
			)
		{
			operand.Parent().Accept(this);
			operand.Index().Accept(this);
		}

		public virtual void Visit(Db4objects.Db4o.Nativequery.Expr.Cmp.MethodCallValue value
			)
		{
			value.Parent().Accept(this);
			VisitArgs(value);
		}

		protected virtual void VisitArgs(Db4objects.Db4o.Nativequery.Expr.Cmp.MethodCallValue
			 value)
		{
			Db4objects.Db4o.Nativequery.Expr.Cmp.IComparisonOperand[] args = value.Args();
			for (int i = 0; i < args.Length; ++i)
			{
				args[i].Accept(this);
			}
		}
	}
}
