' Copyright (C) 2004 - 2006 db4objects Inc. http://www.db4o.com 
Imports com.db4o
Imports com.db4o.query
Imports System.Collections

Namespace com.db4odoc.f1.queries
    Public Class NQExample
        Public Shared ReadOnly YapFileName As String = "formula1.yap"

        Public Shared Sub Main(ByVal args As String())
            Dim db As ObjectContainer = Db4oFactory.OpenFile(YapFileName)
            Try
                StorePilots(db)
                RetrieveComplexSODA(db)
                RetrieveComplexNQ(db)
                RetrieveArbitraryCodeNQ(db)
                ClearDatabase(db)
            Finally
                db.Close()
            End Try
        End Sub
        ' end Main

        Public Shared Sub PrimitiveQuery(ByVal db As ObjectContainer)
            Dim pilots As IList = db.Query(New PilotHundredPoints())
        End Sub
        ' end PrimitiveQuery

        Public Shared Sub StorePilots(ByVal db As ObjectContainer)
            db.[Set](New Pilot("Michael Schumacher", 100))
            db.[Set](New Pilot("Rubens Barrichello", 99))
        End Sub
        ' end StorePilots

        Public Shared Sub RetrieveComplexSODA(ByVal db As ObjectContainer)
            Dim query As Query = db.Query()
            query.Constrain(GetType(Pilot))
            Dim pointQuery As Query = query.Descend("_points")
            query.Descend("_name").Constrain("Rubens Barrichello").[Or](pointQuery.Constrain(99).Greater().[And](pointQuery.Constrain(199).Smaller()))
            Dim result As ObjectSet = query.Execute()
            ListResult(result)
        End Sub
        ' end RetrieveComplexSODA

        Public Shared Sub RetrieveComplexNQ(ByVal db As ObjectContainer)
            Dim result As ObjectSet = db.Query(New ComplexQuery())
            ListResult(result)
        End Sub
        ' end RetrieveComplexNQ

        Public Shared Sub RetrieveArbitraryCodeNQ(ByVal db As ObjectContainer)
            Dim result As ObjectSet = db.Query(New ArbitraryQuery(New Integer() {1, 100}))
            ListResult(result)
        End Sub
        ' end RetrieveArbitraryCodeNQ

        Public Shared Sub ClearDatabase(ByVal db As ObjectContainer)
            Dim result As ObjectSet = db.[Get](GetType(Pilot))
            While result.HasNext()
                db.Delete(result.[Next]())
            End While
        End Sub
        ' end ClearDatabase

        Public Shared Sub ListResult(ByVal result As ObjectSet)
            Console.WriteLine(result.Count)
            For Each item As Object In result
                Console.WriteLine(item)
            Next
        End Sub
        ' end ListResult
    End Class
End Namespace
