#include "DBBalancerXMLConfig.hh"
#include "DBHostConfig.hh"
  
DBBalancerXMLConfig::DBBalancerXMLConfig(string xmlFile) {

  // If the file is not an XML file, lets get out.
  
  if (txtFile.substr(txtFile.length()-4,3)!="xml") {
    ACE_DEBUG((LM_CRITICAL,"(%t, %T) DBBalancer has been compiled to use a XML based configuration file. The expected extension is '.xml'. Found %s\n",txtFile.substr(txtFile.length()-4,3).c_str()));
    ACE_OS::exit(-1);
   
  }


  try {

    XMLPlatformUtils::Initialize();

    ACE_DEBUG((LM_DEBUG,"\nParsing XML data from config file: %s\n ", xmlFile.c_str()));

    SAXParser* _parser = new SAXParser();

    _parser->setDoValidation(true);
    _parser->setErrorHandler(this);
    _parser->setDocumentHandler(this);
    
    _parser->parse(xmlFile.c_str());
    delete _parser;

  } catch (const XMLException &e) {

    ACE_DEBUG((LM_ERROR,"Error while processing config file (%s): %s\n",xmlFile.c_str(), XMLString::transcode(e.getMessage())));
    ACE_OS::exit(-1);

  }

}

DBBalancerXMLConfig::~DBBalancerXMLConfig() {

  ACE_DEBUG((LM_DEBUG,"Destroyed DBBalancerXMLConfig.\n"));

}

// DBBalancerConfig interface implementation. ***************************************************************

// Methods inlined except for this one:

vector <DBHostConfig *> DBBalancerXMLConfig::getHosts() {
  return _hosts;
}


// DocumentHandler interface implementation. *************************************************************

void DBBalancerXMLConfig::characters(const XMLCh *chars, unsigned int length) {

  char *data = XMLString::transcode(chars);
  string dataStr(data);

  ACE_DEBUG((LM_DEBUG,"characters:%s\n",data));

  // <daemon>
  if (_currentElement=="reader-port")
    _readerPort = atoi(data);
  else if (_currentElement=="writer-port")
    _writerPort = atoi(data);

  else if (_currentElement=="init-threads")
    _initThreads = atoi(data);
  else if (_currentElement=="min-threads")
    _minThreads = atoi(data);
  else if (_currentElement=="max-threads")
    _maxThreads = atoi(data);

  else if (_currentElement=="init-db-connections")
    _initDbConnections = atoi(data);
  else if (_currentElement=="min-db-connections")
    _minDbConnections = atoi(data);
  else if (_currentElement=="max-db-connections")
    _maxDbConnections = atoi(data);

  else if (_currentElement=="reaper-delay")
    _reaperDelay = atoi(data);
  else if (_currentElement=="user")
    _daemonUser = (dataStr);
  else if (_currentElement=="password")
    _daemonPassword = (dataStr);

  // <machine>
  
  else if (_currentElement=="host")
    _hosts.back()->setName(dataStr);
  else if (_currentElement=="dbname")
    _hosts.back()->setDbName(dataStr);
  else if (_currentElement=="port")
    _hosts.back()->setDbPort(atoi(data));
  else if (_currentElement=="dbuser")
    _hosts.back()->setDbUser(dataStr);
  else if (_currentElement=="dbpassword")
    _hosts.back()->setDbPassword(dataStr);

  
  free(data);


}
void DBBalancerXMLConfig::endDocument() {

  ACE_DEBUG((LM_DEBUG,"endDocument:\n"));

}

void DBBalancerXMLConfig::endElement(const XMLCh *name) {

  ACE_DEBUG((LM_DEBUG,"endElement:%s\n",XMLString::transcode(name)));

}

void DBBalancerXMLConfig::startDocument() {

  ACE_DEBUG((LM_DEBUG,"Starting XML process.\n"));

}
void DBBalancerXMLConfig::startElement(const XMLCh *name, class AttributeList &attributes) {

  char *element= XMLString::transcode(name);
  string currentElement(element);

  ACE_DEBUG((LM_DEBUG,"startElement:%s\n",element));

  _currentElement = currentElement;

  if ("machine"==_currentElement)
    _hosts.push_back(new DBHostConfig());
  else if ("auth"==_currentElement) {
    // Use the AttributeList to read the "method" attribute.
    char *auth = XMLString::transcode(attributes.getValue("method"));
    string authMethod(auth);
    _daemonAuthMethod = authMethod;
    free(auth);

  }
    

  free(element);

}



