/*
  playerctrl.c
  ===========
  Description: 
    functionality to control 3rd party audio players.

	Copyright (c) 1999, 2000, 2001 Robert Michael S Dean

	Author: Robert Michael S Dean
	Version: 1.0

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/shm.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <gtk/gtk.h>

#include <dbdebug.h>
#include <dbaudiolib.h>
#include <dbchannel.h>
#include <xmms/xmmsctrl.h>

#include "dbplaylist.h"

extern int debug_level;
extern int full_cue_flag;
extern GtkWidget * songlistbox;
extern GtkWidget * player1_label;
extern GtkWidget * player2_label;
extern int cue_index;
extern local_channel * local_channels;
extern player_id player1_id, player2_id, * last_player;
extern unsigned int cue_must_be;

/*****************************************************************/
/***************   Song Handling Functions   ********************/
/***************************************************************/

/* this function borrowed from GTK API reference on GtkDialog */
void db_message_box(gchar *message) 
{
   GtkWidget *dialog, *label, *okay_button;
   
   /* create the widgets */
   
   dialog = gtk_dialog_new();
   label = gtk_label_new (message);
   okay_button = gtk_button_new_with_label("OK");
   
   /* ensure that the dialog box is destroyed when the user clicks ok. */
   
   gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",
                              GTK_SIGNAL_FUNC (gtk_widget_destroy), (gpointer)dialog);
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
                      okay_button);

   /* add the label, and show everything we've added to the dialog. */

   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
                      label);
   gtk_widget_show_all (dialog);
}


/* function to sleep a thread for usec microseconds*/
void db_usleep(gint usec)
{
	struct timeval tv;
	
	tv.tv_sec = usec / 1000000;
	usec -= tv.tv_sec * 1000000;
	tv.tv_usec = usec;
	select(0, NULL, NULL, NULL, &tv);
}

/* send_msg - send a message to a dbmix client application */
void send_msg(gint index, long int type, float data)
{
	local_channel * ch;
	dbfsd_msg msg;

	ch = &(local_channels[index]);

	if(ch->msg_q_id == -1) return;
	
	msg.msg_type = type;
	msg.data = data;

	if(msgsnd(ch->msg_q_id, &msg,sizeof(dbfsd_msg) - sizeof(long int),IPC_NOWAIT) == 0)
	{
	}
	else
	{
	    Error("dbmixer: Message failure sending to channel %d",index);
	}
}

/*
  setup_next_song - takes the song referenced by the cue highlight bar
                    and sends it to a dbmix client
 */
void setup_next_song()
{
	GtkCList * list;
	song_data * sd;
	player_id * player;
	gint pos;

	/* init variables */
	list = (GtkCList *) songlistbox;
	sd = (song_data *) gtk_clist_get_row_data(list,cue_index);

	if (list->rows == 0)
	{
		Debug("list is empty. returning.");
		return;
	}

/* 	if (last_player == &player1_id)  */
/* 	{ */
/* 		player = &player2_id; */
/* 		last_player = &player2_id;		 */
/* 	}  */
/* 	else  */
/* 	{ */
/* 		player = &player1_id; */
/* 		last_player = &player1_id; */
/* 	} */

	/* determine player for this row */
	if (sd->player)
	{
		player = &player2_id;
	}
	else
	{
		player = &player1_id;
	}

	/* check to make sure player is free */
	{
		/* make sure the xmms client is accepting messages */
		if (!xmms_remote_is_running(player->index))
		{
			Error("setup_next_song: could not find xmms remote!  Is xmms running?");
			return;
		}

		/* if full cue mode  */
		if (full_cue_flag)
		{
			/* check to see if player is still playing - and throw error if it is */
			if (xmms_remote_is_playing(player->index))
			{
				db_message_box("\nERROR: \n    Attempted to cue song while player is still playing.    \n");

				return;
			}
		}
		
		/* don;t recue the last song in the list */
		if ((cue_index == (list->rows -1)) && (sd->played))
		{
			Debug("setup_next_song: song is last in list and has already been cued.");
			Debug("                 Returning without setting up next song.");

			db_message_box("\nERROR: \n    Last song in list has already been cued.    \n");

			return;
		}
	}


	/* cue up next song */
	sd->played = TRUE;

	clear_highlight(songlistbox,cue_index);

	/* stop player */
	if (full_cue_flag)
	{
		xmms_remote_stop(player->index);
	}

	/* send song to player */
	xmms_remote_playlist_add_url_string(player->index,sd->path);

	/* make sure the song is the last in the player's list */
	pos = xmms_remote_get_playlist_length(player->index);

	xmms_remote_set_playlist_pos(player->index,pos-1);

	/* if full cue mode, play and pause the next song 
       so that it is ready to go */
	if (full_cue_flag)
	{
		xmms_remote_play(player->index);
		
		usleep(1000);
		
		send_msg(player->index,DBMSG_MUTE,0);
		send_msg(player->index,DBMSG_PAUSE,0);
	}		
	
	/* update player state */
	if (cue_index < (list->rows-1)) 
	{
		cue_index++;
		if (cue_must_be)
		{
			cue_must_be = 0;
		}
		else
		{
			cue_must_be = 1;
		}
	}

	set_cue_highlight(songlistbox);
}

