#!/bin/sh
set -Ceu

# This script once generated the current thin binding.
# Since then, the way GCC generates Ada sources and the dbus header
# may have changed, so running it again will most probably produce a
# different binding, requiring manual changes in the Ada code.
# It is provided to document the process in order to make next update
# or regeneration easier.

thindir=thin
dbus_lib=dbus-1
dbus_includes="`pkg-config --cflags-only-I $dbus_lib | sed s/-I//g`"
dbus_h=`find $dbus_includes -name dbus.h`
CXX=g++-8

if ! mkdir $thindir; then
    echo "The $thindir/ subdirectory exists, and may contain manual changes."
    echo "Please confirm by deleting or renaming it."
    exit 1
fi
cd $thindir

$CXX --dump-ada-spec $dbus_h `pkg-config --cflags $dbus_lib`

# Remove unused files.
rm *_dbus_syntax_h.ads
rm stdarg_h.ads

# Remove arch, path or version dependent prefixes.
for i in *dbus_dbus_*; do
    mv $i `echo $i | sed 's/.*dbus_dbus_/dbus_/'`
done
sed -i 's/[a-z0-9_]*dbus_dbus_/dbus_/g' *

# Fix a warning about unused entities.
sed -i '/^with Interfaces\.C; use Interfaces\.C;$/d' \
    dbus_memory_h.ads \
    dbus_pending_call_h.ads \
    dbus_shared_h.ads

# Remove Ada_2005 pragma. No longer supported by GNAT Community Edition 2018.
sed -i '/^pragma Ada_2005;$/d' *.ads

# Fix inconsistency.
sed -i 's/_h\.Class_DBus\([a-zA-Z0-9_]\+\)\.DBus\1/_h.Dbus\1/g' *
