#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "binary_section.h"

binary_section::binary_section(package_name const &name) :
	name(name)
{
	return;
}

binary_section::attribute binary_section::operator[](std::string const &key)
{
	if(key == "Section")
		return attribute(&binary_section::section, *this);
	if(key == "Depends")
		return attribute(&binary_section::depends, *this);
	if(key == "Description")
		return attribute(&binary_section::description, *this);
	if(key == "Architecture")
		return attribute(&binary_section::architecture, *this);
	throw attribute::unknown_attribute(key);
}

bool binary_section::operator==(binary_section const &rhs) const
{
	if(name != rhs.name)
		return false;
	if(section != rhs.section)
		return false;
	if(depends != rhs.depends)
		return false;
	if(description != rhs.description)
		return false;
	if(architecture != rhs.architecture)
		return false;
	return true;
}

control_file_ostream &operator<<(control_file_ostream &stream, binary_section const &sec)
{
	stream << std::make_pair("Package", sec.name);
	if(!sec.section.empty())
		stream << std::make_pair("Section", sec.section);
	stream << std::make_pair("Architecture", sec.architecture);
	if(!sec.depends.empty())
		stream << std::make_pair("Depends", sec.depends);
	stream << std::make_pair("Description", sec.description);
	return stream;
}
