IceDeb = {
    getClipboardText: function() {
        var clip = Components.classes['@mozilla.org/widget/clipboard;1']
            .getService(Components.interfaces.nsIClipboard);
        if (!clip) return null;

        var trans = Components.classes['@mozilla.org/widget/transferable;1']
            .createInstance(Components.interfaces.nsITransferable);
        if (!trans) return null;

        trans.addDataFlavor("text/unicode");
        clip.getData(trans,
                clip.supportsSelectionClipboard()
                ? clip.kSelectionClipboard
                : clip.kGlobalClipboard
        );

        var s = new Object;
        var p;
        var len = new Object;
        trans.getTransferData("text/unicode", s, len);

        var text = null;
        var res;

        if (s)
            p = s.value.QueryInterface(Components.interfaces.nsISupportsString, res);
        if (p)
            text = p.data.substring(0, len.value / 2);

        return text;
    },
    trim_keyword: function(word) {
        if (!word) return word;

        var oldword;
        do {
            oldword = word;

            word = word.replace(/^[^a-zA-Z0-9]+/, '');
            word = word.replace(/[^a-zA-Z0-9]+$/, '');
            word = word.replace(/^Bug#/i, '');
        } while ( oldword != word );

        return word;
    },
    lookup_bts: function(in_new) {
        var bug = IceDeb.trim_keyword(IceDeb.getClipboardText());
        if (!bug) return null;
        var uri="http://bugs.debian.org/" + bug;

        if (in_new) {
            var b = getBrowser();
            var new_tab = b.addTab(uri);
            b.selectedTab = new_tab;
        }
        else {
            loadURI(uri);
        }
    },
    lookup_pts: function(in_new) {
        var pkg = IceDeb.trim_keyword(IceDeb.getClipboardText());
        if (!pkg) return null;
        var uri="http://packages.qa.debian.org/" + pkg;

        if (in_new) {
            var b = getBrowser();
            var new_tab = b.addTab(uri);
            b.selectedTab = new_tab;
        }
        else {
            loadURI(uri);
        }
    },
    lookup_deb: function(in_new) {
        var pkg = IceDeb.trim_keyword(IceDeb.getClipboardText());
        if (!pkg) return null;
        var uri="http://packages.debian.org/" + pkg;

        if (in_new) {
            var b = getBrowser();
            var new_tab = b.addTab(uri);
            b.selectedTab = new_tab;
        }
        else {
            loadURI(uri);
        }
    },
    lookup_ml: function(in_new) {
        var msg_id = IceDeb.trim_keyword(IceDeb.getClipboardText());
        if (!msg_id) msg_id = '';
        var uri="http://lists.debian.org/msgid-search/" + msg_id;

        if (in_new) {
            var b = getBrowser();
            var new_tab = b.addTab(uri);
            b.selectedTab = new_tab;
        }
        else {
            loadURI(uri);
        }
    },
    lookup_ddpo: function(in_new) {
        var keyword = IceDeb.trim_keyword(IceDeb.getClipboardText());
        var uri="http://qa.debian.org/developer.php";

        if (keyword) uri += "?login=" + keyword;

        if (in_new) {
            var b = getBrowser();
            var new_tab = b.addTab(uri);
            b.selectedTab = new_tab;
        }
        else {
            loadURI(uri);
        }
    },
    lookup_buildd: function(in_new) {
        var keyword = IceDeb.trim_keyword(IceDeb.getClipboardText());
        var uri="https://buildd.debian.org/";

        if (keyword) uri += keyword;

        if (in_new) {
            var b = getBrowser();
            var new_tab = b.addTab(uri);
            b.selectedTab = new_tab;
        }
        else {
            loadURI(uri);
        }
    },
    lookup_security: function(in_new) {
        var keyword = IceDeb.trim_keyword(IceDeb.getClipboardText());
        var uri="http://security-tracker.debian.org/";

        if (keyword) uri += "tracker/" + keyword;

        if (in_new) {
            var b = getBrowser();
            var new_tab = b.addTab(uri);
            b.selectedTab = new_tab;
        }
        else {
            loadURI(uri);
        }
    },

    btsButton: function (e) {
        if ( e.button == 0 )
            IceDeb.lookup_bts(false)
        else if ( e.button == 1 )
            IceDeb.lookup_bts(true);
    },
    ptsButton: function (e) {
        if ( e.button == 0 )
            IceDeb.lookup_pts(false)
        else if ( e.button == 1 )
            IceDeb.lookup_pts(true);
    },
    debButton: function (e) {
        if ( e.button == 0 )
            IceDeb.lookup_deb(false)
        else if ( e.button == 1 )
            IceDeb.lookup_deb(true);
    },
    mlButton: function (e) {
        if ( e.button == 0 )
            IceDeb.lookup_ml(false)
        else if ( e.button == 1 )
            IceDeb.lookup_ml(true);
    },
    ddpoButton: function (e) {
        if ( e.button == 0 )
            IceDeb.lookup_ddpo(false)
        else if ( e.button == 1 )
            IceDeb.lookup_ddpo(true);
    },
    builddButton: function (e) {
        if ( e.button == 0 )
            IceDeb.lookup_buildd(false)
        else if ( e.button == 1 )
            IceDeb.lookup_buildd(true);
    },
    securityButton: function (e) {
        if ( e.button == 0 )
            IceDeb.lookup_security(false)
        else if ( e.button == 1 )
            IceDeb.lookup_security(true);
    }
}

