/*
 * search_line.c
 *   $Last modified: Thu Mar 30 22:06:01 2000$
 * $Id: search_line.c,v 1.3 2000/03/30 13:09:24 kamop Exp $
 */

#define _SEARCH_LINE_C

#include <stdio.h>
#include <ctype.h>
#include "debwrap.h"

#define PREPARE_REGEXP_STR "Preparing to replace (.+) (.+) \\(using.*"
regex_t prepare_preg;

#define SETUP_REGEXP_STR "Setting up (.+) \\(([^-]+)(|-[^-]+)\\) ..."
regex_t setup_preg;

#define CONFIGURING_REGEXP_STR "Configuring (.+)\n"
regex_t configuring_preg;

#define CONFIGURATION_REGEXP_STR "(.+) Configuration\n"
regex_t configuration_preg;

#define READING_REGEXP_STR "\\(Reading database \\.\\.\\..*"
regex_t reading_preg;

/*
 * MODULE: init_search_line
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void init_search_line()
{
  regcomp(&prepare_preg, PREPARE_REGEXP_STR, REG_EXTENDED);
  regcomp(&setup_preg, SETUP_REGEXP_STR, REG_EXTENDED);
  regcomp(&configuring_preg, CONFIGURING_REGEXP_STR, REG_EXTENDED);
  regcomp(&configuration_preg, CONFIGURATION_REGEXP_STR, REG_EXTENDED);
  regcomp(&reading_preg, READING_REGEXP_STR, REG_EXTENDED);
}

/*
 * MODULE: search_line
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
char *search_line(char *line)
{
  char *str;

  /* Package specific search */
#ifdef DEBUG
  fprintf(logfp, "Cheking '%s'\n", line);
  fprintf(logfp, "Search from PRESET\n");
#endif
  set_qanda_type(PRESET);
  if((str = search_qanda_line(line)) != NULL){
#ifdef DEBUG
    fprintf(logfp, "Hit qanda preset [%s]\n", str);
#endif
    return(str);
  }

  /* Package specific search */
#ifdef DEBUG
  fprintf(logfp, "Search from PACKAGE\n");
#endif
  set_qanda_type(PACKAGE);
  if((str = search_qanda_line(line)) != NULL){
#ifdef DEBUG
    fprintf(logfp, "Hit qanda package [%s]\n", str);
#endif
    return(str);
  }

  /* */
#ifdef DEBUG
  fprintf(logfp, "Search from default\n");
#endif
  if(search_setup_line(line) == 0){
#ifdef DEBUG
    fprintf(logfp, "Hit setup_line\n");
#endif
    return(NULL);
  }

  /* */
#ifdef DEBUG
  fprintf(logfp, "Search from FREQ\n");
#endif
  set_qanda_type(FREQ);
  if((str = search_qanda_line(line)) != NULL){
#ifdef DEBUG
    fprintf(logfp, "Hit FREQ[%s]\n", str);
#endif
    return(str);
  }
  return(NULL);
} /* search_line() */

/*
 * MODULE: search_qanda_line
 * DESC:
 * IN: char *line   1 line strings which is to be checked
 * OUT: char *answer   answer strings or NULL
 * OP:
 * STATUS:
 * END:
 */
char *search_qanda_line(char *line)
{
  int qanda_end = get_qanda_end();
  int i;
  qanda_t *qanda;
  regmatch_t pmatch[10];


#ifdef DEBUG
  fprintf(logfp, "\nLINE(%d): %s\n", qanda_end, line);
#endif

  if(qanda_end > 0){
    for(i = 0; i < qanda_end; i++){
      qanda = get_qanda(i);
#ifdef DEBUG
      fprintf(logfp, "Compare with '%s'\n", qanda->q);
#endif
      if(regexec(&qanda->qr, line, 10, pmatch, REG_NOTBOL) != REG_NOMATCH){
        return(qanda->a);
      }
    } /* for(i) */
  } /* if(qanda) */
  return(NULL);
} /* search_qanda_line() */

/*
 * MODULE: search_setup_line
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
int search_setup_line(char *line)
{
  regmatch_t pmatch[4];
  char package[BUFSIZE];
  char up_ver[BUFSIZE];
  char deb_ver[BUFSIZE];

  /*printf("%s\n", string);*/
  if(regexec(&prepare_preg, line, 4, pmatch, REG_NOTBOL) == 0){
    strncpy(package, (line + pmatch[1].rm_so),
            (pmatch[1].rm_eo - pmatch[1].rm_so));
    package[pmatch[1].rm_eo - pmatch[1].rm_so] = '\0';
#if 0
    strncpy(up_ver, (line + pmatch[2].rm_so),
            (pmatch[2].rm_eo - pmatch[2].rm_so));
    up_ver[pmatch[2].rm_eo - pmatch[2].rm_so] = '\0';
    strncpy(deb_ver, (line + pmatch[3].rm_so),
            (pmatch[3].rm_eo - pmatch[3].rm_so));
    deb_ver[pmatch[3].rm_eo - pmatch[3].rm_so] = '\0';
#else
    up_ver[0] = '\0';
    deb_ver[0] = '\0';
#endif
#ifdef MESSAGE
    fprintf(logfp, "DEBWRAP::QANDA File (%s) (%s) (%s)\n", package, up_ver, deb_ver);
#endif /* MESSAGE */
    set_qanda_package(package);
    set_qanda_up_ver(up_ver);
    set_qanda_deb_ver(deb_ver);
    set_qanda_type(PACKAGE);
    setup_qanda();
    store_qanda_type(PACKAGE);
    return(1);
  }
  if(regexec(&setup_preg, line, 4, pmatch, REG_NOTBOL) == 0){
    strncpy(package, (line + pmatch[1].rm_so),
            (pmatch[1].rm_eo - pmatch[1].rm_so));
    package[pmatch[1].rm_eo - pmatch[1].rm_so] = '\0';
    strncpy(up_ver, (line + pmatch[2].rm_so),
            (pmatch[2].rm_eo - pmatch[2].rm_so));
    up_ver[pmatch[2].rm_eo - pmatch[2].rm_so] = '\0';
    strncpy(deb_ver, (line + pmatch[3].rm_so),
            (pmatch[3].rm_eo - pmatch[3].rm_so));
    deb_ver[pmatch[3].rm_eo - pmatch[3].rm_so] = '\0';
#ifdef MESSAGE
    fprintf(logfp, "DEBWRAP::QANDA File (%s) (%s) (%s)\n", package, up_ver, deb_ver);
#endif /* MESSAGE */
    set_qanda_package(package);
    set_qanda_up_ver(up_ver);
    set_qanda_deb_ver(deb_ver);
    set_qanda_type(PACKAGE);
    setup_qanda();
    store_qanda_type(PACKAGE);
    return(1);
  }
  if(regexec(&configuring_preg, line, 4, pmatch, REG_NOTBOL) == 0){
    strncpy(package, (line + pmatch[1].rm_so),
            (pmatch[1].rm_eo - pmatch[1].rm_so));
    package[pmatch[1].rm_eo - pmatch[1].rm_so] = '\0';
    if(isupper(package[0])){
      package[0] += 0x20;
#ifdef MESSAGE
      fprintf(logfp, "DEBWRAP::QANDA File (%s)\n", package);
#endif /* MESSAGE */
      set_qanda_package(package);
      set_qanda_up_ver("");
      set_qanda_deb_ver("");
      set_qanda_type(PACKAGE);
      setup_qanda();
      store_qanda_type(PACKAGE);
      return(1);
    }
  }
  if(regexec(&configuration_preg, line, 4, pmatch, REG_NOTBOL) == 0){
    strncpy(package, (line + pmatch[1].rm_so),
            (pmatch[1].rm_eo - pmatch[1].rm_so));
    package[pmatch[1].rm_eo - pmatch[1].rm_so] = '\0';
    if(isupper(package[0])){
      package[0] += 0x20;
#ifdef MESSAGE
      fprintf(logfp, "DEBWRAP::QANDA File (%s)\n", package);
#endif /* MESSAGE */
      set_qanda_package(package);
      set_qanda_up_ver("");
      set_qanda_deb_ver("");
      set_qanda_type(PACKAGE);
      setup_qanda();
      store_qanda_type(PACKAGE);
      return(1);
    }
  }
  if(regexec(&reading_preg, line, 4, pmatch, REG_NOTBOL) == 0){
#ifdef MESSAGE
    fprintf(logfp, "DEBWRAP::Clear QANDA file\n");
#endif /* MESSAGE */
    clear_qanda();
    return(0);
  }
  return(1);
} /* search_line() */
