
#include "delo.h"

#include <linux/elf.h>

extern const struct callback *callv;

#undef NOCOPY

void *copyelf(void *fb) {
	Elf32_Ehdr	*fhdr = fb;
	Elf32_Shdr	*shdr;	
	int		i;

	if (fhdr->e_machine != EM_MIPS) {
		printf("No Mips ELF\n");
		return(0);	
	}

#ifdef DEBUG
	printf("fhdr->e_entry = %lx\n", fhdr->e_entry);

	printf("fhdr->e_shoff = %d/%x\n", fhdr->e_shoff, fhdr->e_shoff);
	printf("fhdr->e_phoff = %d/%x\n", fhdr->e_phoff, fhdr->e_phoff);

	printf("fhdr->e_shentsize = %d\n", fhdr->e_shentsize);
	printf("fhdr->e_shnum = %d\n", fhdr->e_shnum);
	printf("fhdr->e_shstrndx = %lx\n", fhdr->e_shstrndx);

	printf("fhdr->e_phentsize = %lx\n", fhdr->e_phentsize);
	printf("fhdr->e_phnum = %lx\n", fhdr->e_phnum);
#endif

	shdr=fb + fhdr->e_shoff;

	for(i=0;i<fhdr->e_shnum;i++,shdr++) {

#ifdef DEBUG
		printf("%2d %08x %08x %08x %08x %08x %08x\n",
			i, (unsigned long) ( (char *) shdr - (char *) fb ),
			shdr->sh_type, shdr->sh_addr,
			shdr->sh_offset, shdr->sh_size);
#endif

		if (shdr->sh_size <= 0) 
			continue;

		if (shdr->sh_type == SHT_PROGBITS) {
#ifdef DEBUG
			printf("memcpy(%lx, %lx + %lx, %lx)\n",
					shdr->sh_addr,
					fb,shdr->sh_offset, 
					shdr->sh_size);
#endif
#ifndef NOCOPY
			memcpy((void *) shdr->sh_addr,
				fb + shdr->sh_offset,
				shdr->sh_size);
#endif

		} else if (shdr->sh_type == SHT_NOBITS) {
#ifdef DEBUG
			printf("memset(%lx, 0x0, %lx)\n",
					shdr->sh_addr,
					shdr->sh_size);
#endif
#ifndef NOCOPY
			memset((void *) shdr->sh_addr, 0x0, shdr->sh_size);
#endif
		}
	}
	return((void *) fhdr->e_entry);
}

