#ifndef _DEC_PROM_H
#define _DEC_PROM_H 1

#define DEC_REX_MAGIC 		0x30464354

/* Function offsets we actually use */
#define PROM_PUTS		0x2c
#define PROM_PRINTF		0x30
#define PROM_BOOTINIT       	0x54
#define PROM_BOOTREAD       	0x58

/* The size of each function */
#define PROM_FSIZE		4

typedef void (*psig_t)(int);
typedef int jmp_buf[12];

struct callback {
	char	unused1[PROM_PUTS-1];				/* unused functions */
	int	(*_puts) (char *s);				/* 2c */
	int	(*_printf) (char *fmt, ...);			/* 30 */	
	char	unused2[PROM_BOOTINIT-PROM_PUTS-PROM_FSIZE*2];	/* unused functions */
	int	(*_bootinit) (char *fname);			/* 54 */
	int	(*_bootread) (int b, void *buffer, int n);	/* 58 */
};

extern const struct callback *callv;

#endif /* !_DEC_PROM_H */
