/* scoreops.c
 * functions dealing with the whole score

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001 Matthew Hiller */

#include "datastructures.h"
#include "staffops.h"

#define INITIAL_WHOLEWIDTH 160
#define INITIAL_STAFFHEIGHT 100

void
init_score (struct scoreinfo *si)
{
  si->leftmeasurenum = si->rightmeasurenum = 1;
  si->top_staff = si->bottom_staff = 1;
  si->measurewidth = INITIAL_WHOLEWIDTH;
  si->measurewidths = NULL;
  si->staffspace = INITIAL_STAFFHEIGHT;

  si->thescore = NULL;
  si->currentstaffnum = 1;
  si->currentmeasurenum = 1;
  si->currentobject = NULL;
  si->cursor_x = 0;
  si->cursor_y = 0;
  si->staffletter_y = 0;
  si->cursor_appending = TRUE;
  si->rest_mode = FALSE;
  si->cursoroffend = FALSE;
  si->markstaffnum = 0;
  si->markmeasurenum = 0;
  si->markcursor_x = 0;
  si->haschanged = FALSE;
  si->is_grace_mode = FALSE;
  /*playback purposes */
  si->tempo = 60;
  si->start = 0;
  si->end = 0;
  si->stafftoplay = 0;

  si->savebuffer = NULL;

  /* Header info */
  si->title = g_string_new ("");
  si->subtitle = g_string_new ("");
  si->composer = g_string_new ("");
  si->filename = g_string_new ("");
}

void
free_score (struct scoreinfo *si)
{
  si->currentstaff = si->thescore;
  si->currentstaffnum = 1;
  while (removestaff (si, 1, 1))
    ;
  g_list_free (si->measurewidths);
  g_string_free (si->title, FALSE);
  g_string_free (si->subtitle, FALSE);
  g_string_free (si->composer, FALSE);
  g_string_free (si->filename, FALSE);
  gtk_window_set_title (GTK_WINDOW (si->window), "Denemo");
  init_score (si);
}
