/* slurs.c
 *
 * Functions for drawing slurs
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000, 2001 Adam Tee, Matthew Hiller
 */

#include "datastructures.h"
#include "utils.h"		/* Includes <gdk.h> */

GSList *
push_slur_stack (GSList * slur_stack, gint x)
{
  slur_stack = g_slist_prepend (slur_stack, GINT_TO_POINTER (x));
  return slur_stack;
}

gint top_slur_stack (GSList * slur_stack)
{
  if (slur_stack)
    return GPOINTER_TO_INT (slur_stack->data);
  else
    return -1;
}

GSList *
pop_slur_stack (GSList * slur_stack)
{
  if (slur_stack)
    {
      GSList *head = slur_stack;

      slur_stack = g_slist_remove_link (slur_stack, head);
      g_slist_free_1 (head);
      return slur_stack;
    }
  else
    return NULL;
}

void
draw_slur (GdkPixmap * pixmap, GdkGC * gc, GSList ** slur_stack,
	   gint x2, gint y)
{
  gint x1 = top_slur_stack (*slur_stack);
  if (x1 != -1)
    {
      *slur_stack = pop_slur_stack (*slur_stack);
      gdk_draw_arc (pixmap, gc, FALSE, x1, y - 15, x2 - x1, 8, 0, 64 * 180);
    }
}
