/* keyresponses.h
 * function prototypes for responses to user keypresses
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller
 */

#ifndef KEYRESPONSES_H
#define KEYRESPONSES_H

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "commandfuncs.h"
#include <denemo/denemo.h>
#include "draw.h"
#include "selectops.h"
#include "chordops.h"
#include "objops.h"


void scorearea_keypress_event (GtkWidget * widget, GdkEventKey * event,
			       gpointer data);

void adjust_measure_less_width_key (scoreinfo *si);
void adjust_measure_more_width_key (scoreinfo *si);
void adjust_staff_less_height_key (scoreinfo *si);
void adjust_staff_more_height_key (scoreinfo *si);
void unset_selection_key (scoreinfo *si);
void insert_chord_key (scoreinfo *si);
void go_to_A_key (scoreinfo *si);
void go_to_B_key (scoreinfo *si);
void go_to_C_key (scoreinfo *si);
void go_to_D_key (scoreinfo *si);
void go_to_E_key (scoreinfo *si);
void go_to_F_key (scoreinfo *si);
void go_to_G_key (scoreinfo *si);
void octave_up_key (scoreinfo *si);
void octave_down_key (scoreinfo *si);
void rest_toggle_key (GtkAction *action, scoreinfo *si);
void toggle_blank(scoreinfo *si);
void append_measure_key (scoreinfo *si);
void insert_measure_key (scoreinfo *si);


void insert_chord_0key (scoreinfo *si);
void insert_chord_1key (scoreinfo *si);
void insert_chord_2key (scoreinfo *si);
void insert_chord_3key (scoreinfo *si);
void insert_chord_4key (scoreinfo *si);
void insert_chord_5key (scoreinfo *si);
void insert_chord_6key (scoreinfo *si);
void insert_blankchord_0key (scoreinfo *si);
void insert_blankchord_1key (scoreinfo *si);
void insert_blankchord_2key (scoreinfo *si);
void insert_blankchord_3key (scoreinfo *si);
void insert_blankchord_4key (scoreinfo *si);
void insert_blankchord_5key (scoreinfo *si);
void insert_blankchord_6key (scoreinfo *si);
void insert_rest_0key (scoreinfo *si);
void insert_rest_1key (scoreinfo *si);
void insert_rest_2key (scoreinfo *si);
void insert_rest_3key (scoreinfo *si);
void insert_rest_4key (scoreinfo *si);
void insert_rest_5key (scoreinfo *si);
void insert_rest_6key (scoreinfo *si);

void insert_duplet (scoreinfo *si);
void insert_triplet (scoreinfo *si);
void insert_quadtuplet (scoreinfo *si);
void insert_quintuplet (scoreinfo *si);
void insert_sextuplet (scoreinfo *si);
void insert_septuplet (scoreinfo *si);
void add_tone_key (scoreinfo *si);
void remove_tone_key (scoreinfo *si);
void backspace_key (scoreinfo *si);
void sharpen_key (scoreinfo *si);
void flatten_key (scoreinfo *si);
void tie_notes_key (scoreinfo *si);
void add_dot_key (scoreinfo *si);
void remove_dot_key (scoreinfo *si);
void insert_clone_key (scoreinfo *si);
void add_staccato(scoreinfo *si);
void add_fermata(scoreinfo *si);
void add_accent(scoreinfo *si);
void add_tenuto(scoreinfo *si);
void add_mordent(scoreinfo *si);
void add_turn(scoreinfo *si);
void add_trill(scoreinfo *si);
void add_staccatissimo(scoreinfo *si);
void set_grace(scoreinfo *si);
void force_cautionary(scoreinfo *si);
void change_pitch(scoreinfo *si);
void add_coda(scoreinfo *si);
void add_flageolet(scoreinfo *si);
void add_open(scoreinfo *si);
void add_prallmordent(scoreinfo *si);
void add_prallprall(scoreinfo *si);
void add_prall(scoreinfo *si);
void add_reverseturn(scoreinfo *si);
void add_segno(scoreinfo *si);
void add_sforzato(scoreinfo *si);
void add_stopped(scoreinfo *si);
void add_thumb(scoreinfo *si);
void add_trillelement(scoreinfo *si);
void add_trill_element(scoreinfo *si);
void add_upprall(scoreinfo *si);
void add_arpeggio(scoreinfo *si);	
void default_mode(GtkAction *action, scoreinfo *si);
void replace_mode(GtkAction *action, scoreinfo *si);
void insert_mode(GtkAction *action, scoreinfo *si);
void insert_opencloserepeat(scoreinfo *si);
void insert_closerepeat(scoreinfo *si);
void insert_openrepeat(scoreinfo *si);
void insert_endbar(scoreinfo *si);
void insert_doublebar (scoreinfo *si);
void blank_mode (GtkAction *action, scoreinfo *si);
void newcleftreble (scoreinfo *si);
void newclefbass (scoreinfo *si);
void newclefg8 (scoreinfo *si);
void newclefalto (scoreinfo *si);
void newcleftenor (scoreinfo *si);
void newclefsoprano (scoreinfo *si);

void setcleftreble (scoreinfo *si);
void setclefbass (scoreinfo *si);
void setclefg8 (scoreinfo *si);
void setclefalto (scoreinfo *si);
void setcleftenor (scoreinfo *si);
void setclefsoprano (scoreinfo *si);

void newtimesig22(scoreinfo *si);
void newtimesig42(scoreinfo *si);
void newtimesig32(scoreinfo *si);
void newtimesig44(scoreinfo *si);
void newtimesig54(scoreinfo *si);
void newtimesig24(scoreinfo *si);
void newtimesig34(scoreinfo *si);
void newtimesig68(scoreinfo *si);
void newtimesig128(scoreinfo *si);
void newtimesig38(scoreinfo *si);
void newtimesig98(scoreinfo *si);
void newtimesig64(scoreinfo *si);


void settimesig22(scoreinfo *si);
void settimesig42(scoreinfo *si);
void settimesig32(scoreinfo *si);
void settimesig44(scoreinfo *si);
void settimesig54(scoreinfo *si);
void settimesig24(scoreinfo *si);
void settimesig34(scoreinfo *si);
void settimesig68(scoreinfo *si);
void settimesig128(scoreinfo *si);
void settimesig38(scoreinfo *si);
void settimesig98(scoreinfo *si);
void settimesig64(scoreinfo *si);

void newkeysigcmaj(scoreinfo *si);
void newkeysiggmaj(scoreinfo *si);
void newkeysigdmaj(scoreinfo *si);
void newkeysigamaj(scoreinfo *si);
void newkeysigemaj(scoreinfo *si);
void newkeysigbmaj(scoreinfo *si);
void newkeysigfsharpmaj(scoreinfo *si);
void newkeysigcsharpmaj(scoreinfo *si);
void newkeysigfmaj(scoreinfo *si);
void newkeysigbflatmaj(scoreinfo *si);
void newkeysigeflatmaj(scoreinfo *si);
void newkeysigaflatmaj(scoreinfo *si);
void newkeysigdflatmaj(scoreinfo *si);
void newkeysiggflatmaj(scoreinfo *si);
void newkeysigcflatmaj(scoreinfo *si);

void newkeysigamin(scoreinfo *si);
void newkeysigemin(scoreinfo *si);
void newkeysigbmin(scoreinfo *si);
void newkeysigfsharpmin(scoreinfo *si);
void newkeysigcsharpmin(scoreinfo *si);
void newkeysiggsharpmin(scoreinfo *si);
void newkeysigdsharpmin(scoreinfo *si);
void newkeysigasharpmin(scoreinfo *si);
void newkeysigdmin(scoreinfo *si);
void newkeysiggmin(scoreinfo *si);
void newkeysigcmin(scoreinfo *si);
void newkeysigfmin(scoreinfo *si);
void newkeysigbflatmin(scoreinfo *si);
void newkeysigeflatmin(scoreinfo *si);
void newkeysigaflatmin(scoreinfo *si);


void setkeysigcmaj(scoreinfo *si);
void setkeysiggmaj(scoreinfo *si);
void setkeysigdmaj(scoreinfo *si);
void setkeysigamaj(scoreinfo *si);
void setkeysigemaj(scoreinfo *si);
void setkeysigbmaj(scoreinfo *si);
void setkeysigfsharpmaj(scoreinfo *si);
void setkeysigcsharpmaj(scoreinfo *si);
void setkeysigfmaj(scoreinfo *si);
void setkeysigbflatmaj(scoreinfo *si);
void setkeysigeflatmaj(scoreinfo *si);
void setkeysigaflatmaj(scoreinfo *si);
void setkeysigdflatmaj(scoreinfo *si);
void setkeysiggflatmaj(scoreinfo *si);
void setkeysigcflatmaj(scoreinfo *si);

void setkeysigamin(scoreinfo *si);
void setkeysigemin(scoreinfo *si);
void setkeysigbmin(scoreinfo *si);
void setkeysigfsharpmin(scoreinfo *si);
void setkeysigcsharpmin(scoreinfo *si);
void setkeysiggsharpmin(scoreinfo *si);
void setkeysigdsharpmin(scoreinfo *si);
void setkeysigasharpmin(scoreinfo *si);
void setkeysigdmin(scoreinfo *si);
void setkeysiggmin(scoreinfo *si);
void setkeysigcmin(scoreinfo *si);
void setkeysigfmin(scoreinfo *si);
void setkeysigbflatmin(scoreinfo *si);
void setkeysigeflatmin(scoreinfo *si);
void setkeysigaflatmin(scoreinfo *si);
#endif //KEYRESPONSES_H
