/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "asactivity.h"

ASActivity::ASActivity(QVariantMap activityMap,
                       QObject *parent) : QObject(parent)
{
    id = activityMap.value("id").toString();


    // Get the author of the _activity_ (not the object)
    this->asAuthor = new ASPerson(activityMap.value("actor").toMap(), this);

    // Get the object included with the activity: the post itself, or whatever
    this->asObject = new ASObject(activityMap.value("object").toMap(), this);

    // If the object is a person, as in an activity where someone adds someone else
    if (asObject->getType() == "person")
    {
        this->asPersonObject = new ASPerson(activityMap.value("object").toMap(), this);
    }
    else
    {
        // Otherwise, at least initialize empty, but valid
        this->asPersonObject = new ASPerson(QVariantMap(), this);
    }

    // Get possible "target"
    this->asTarget = new ASObject(activityMap.value("target").toMap(), this);

    // FIXME: add bools hasAuthor, hasObject and hasTarget, maybe?


    // Activity verb: post, share...
    verb = activityMap.value("verb").toString();

    if (verb == "share")
    {
        shared = true;
        sharedByName = asAuthor->getName();
        sharedById = asAuthor->getId();
        sharedByAvatar = asAuthor->getAvatar();
    }
    else
    {
        shared = false;
    }


    // Timestamps
    createdAt = activityMap.value("published").toString();
    updatedAt = activityMap.value("updated").toString();

    // Software used to generate the activity: webUI, a client, a service...
    generator = activityMap.value("generator").toMap().value("displayName").toString();

    // Content of the activity, usually a description like "User followed someone"
    content = activityMap.value("content").toString();


    // Audience: To
    QVariantMap postToMap;
    foreach (QVariant postToVariant, activityMap.value("to").toList())
    {
        postToMap = postToVariant.toMap();

        QString toId = postToMap.value("id").toString();
        if (toId == "http://activityschema.org/collection/public")
        {
            toString += "<b>" + tr("Public") + "</b>, ";
        }
        else
        {
            QString displayName = postToMap.value("displayName").toString().trimmed();
            displayName = MiscHelpers::fixLongName(displayName);
            if (!displayName.isEmpty())
            {
                toString += "<a href=\"" + postToMap.value("url").toString() + "\">"
                            + displayName + "</a>, ";
            }

            recipientsIdList.append(toId);
        }
    }
    toString.remove(-2, 2); // remove last comma and space


    // and CC
    QVariantMap postCCMap;
    foreach (QVariant postCCVariant, activityMap.value("cc").toList())
    {
        postCCMap = postCCVariant.toMap();

        QString ccId = postCCMap.value("id").toString();
        if (ccId == "http://activityschema.org/collection/public")
        {
            ccString += "<b>" + tr("Public") + "</b>, ";
        }
        else
        {
            QString displayName = postCCMap.value("displayName").toString().trimmed();
            displayName = MiscHelpers::fixLongName(displayName);
            if (!displayName.isEmpty())
            {
                ccString += "<a href=\"" + postCCMap.value("url").toString() + "\">"
                          + displayName + "</a>, ";
            }

            recipientsIdList.append(ccId);
        }
    }
    ccString.remove(-2, 2);


    qDebug() << "ASActivity created" << this->id;
}



ASActivity::~ASActivity()
{
    qDebug() << "ASActivity destroyed" << this->id;
}



////// Getters!

ASPerson *ASActivity::author()
{
    return this->asAuthor;
}

ASObject *ASActivity::object()
{
    return this->asObject;
}

ASObject *ASActivity::target()
{
    return this->asTarget;
}

ASPerson *ASActivity::personObject()
{
    return this->asPersonObject;
}


QString ASActivity::getId()
{
    return this->id;
}

QString ASActivity::getVerb()
{
    return this->verb;
}

QString ASActivity::getGenerator()
{
    return this->generator;
}

QString ASActivity::getCreatedAt()
{
    return this->createdAt;
}

QString ASActivity::getUpdatedAt()
{
    return this->updatedAt;
}

QString ASActivity::getContent()
{
    return this->content;
}

QString ASActivity::getToString()
{
    return this->toString;
}

QString ASActivity::getCCString()
{
    return this->ccString;
}

QStringList ASActivity::getRecipientsIdList()
{
    return this->recipientsIdList;
}


bool ASActivity::isShared()
{
    return this->shared;
}

QString ASActivity::getSharedByName()
{
    return this->sharedByName;
}

QString ASActivity::getSharedById()
{
    return this->sharedById;
}

QString ASActivity::getSharedByAvatar()
{
    return this->sharedByAvatar;
}
