/*
 * Copyright (c) 2007-2009, Sergey Zorin. All rights reserved.
 *
 * This software is distributable under the BSD license. See the terms
 * of the BSD license in the COPYING file provided with this software.
 *
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <string.h>

#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include <gtk/gtkaboutdialog.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "model.h"

extern GtkListStore* list_model;

void
on_ok_clicked(GtkButton* button, gpointer user_data) {
  apply();
  gtk_main_quit();
}

void
on_apply_clicked(GtkButton* button, gpointer user_data) {
  apply();
}

void
on_about_clicked(GtkButton* button, gpointer user_data) {
  const gchar *authors[] = {
    "Sergey Zorin <szorin@comcast.net>",
    NULL
  };
  
  const gchar *documenters[] = {
    "Sergey Zorin <szorin@comcast.net>",
    NULL
  };
  
  const gchar *license = {
    _("Copyright (c) 2007-2009 Sergey Zorin\n"
      "All rights reserved.\n"
      "\n"
      "Redistribution and use in source and binary forms, with or without "
      "modification, are permitted provided that the following conditions "
      "are met:\n"
      "   1. Redistributions  of  source  code   must  retain  the  above "
      "copyright notice,  this list of conditions and the following "
      "disclaimer.\n"
      "   2. Redistributions in binary  form  must  reproduce  the  above "
      "copyright notice,  this list of conditions and the following "
      "disclaimer  in  the  documentation  and/or  other  materials "
      "provided with the distribution.\n"
      "\n"
      "THIS SOFTWARE  IS  PROVIDED  BY  THE  COPYRIGHT  HOLDERS  AND  CONTRIBUTORS "
      "\"AS IS\" AND ANY EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT LIMITED "
      "TO, THE IMPLIED WARRANTIES  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR "
      "PURPOSE  ARE  DISCLAIMED.  IN  NO  EVENT  SHALL  THE  COPYRIGHT   OWNER  OR "
      "CONTRIBUTORS  BE  LIABLE  FOR  ANY DIRECT,  INDIRECT, INCIDENTAL,  SPECIAL, "
      "EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES  (INCLUDING,  BUT  NOT  LIMITED  TO, "
      "PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; "
      "OR BUSINESS INTERRUPTION)  HOWEVER CAUSED AND ON ANY THEORY  OF  LIABILITY, "
      "WHETHER IN CONTRACT,  STRICT LIABILITY,  OR  TORT  (INCLUDING NEGLIGENCE OR "
      "OTHERWISE) ARISING  IN  ANY WAY OUT OF THE USE  OF THIS  SOFTWARE,  EVEN IF "
      "ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.")
  };
  
  gtk_show_about_dialog(GTK_WINDOW(user_data),
#if GTK_CHECK_VERSION(2, 11, 0)
    "program-name", _("diff-ext"),
#else
    "name", _("diff-ext"),
#endif /* GTK 2.11. 0 */
    "version", VERSION,
    "comments", _(""),
    "copyright", _("Copyright © 2007-2009 Sergey Zorin"),
    "license", license,
    "wrap-license", TRUE,
    "authors", authors,
    "documenters", documenters,
    /* Translators should localize the following string
    * which will be displayed at the bottom of the about
    * box to give credit to the translator(s).
    */
    "translator-credits", _("translator-credits"),
    "logo-icon-name", "de",
    "website", "http://diff-ext.sourceforge.net",
    "website-label", _("gdiff-ext Web Site"),
    NULL);
}

void
on_3_way_compare_toggled(GtkToggleButton* togglebutton, gpointer user_data) {
  MODEL* m = (MODEL*)model;
  m->enable_diff3 = gtk_toggle_button_get_active(togglebutton);
}

void
on_diff_tool_selection_changed(GtkFileChooser* filechooser, gpointer user_data) {
  MODEL* m = (MODEL*)model;
  gchar* name = gtk_file_chooser_get_filename(filechooser);
  if(name != NULL) {
    g_string_assign(m->diff_tool, name);
  }
}

void
on_diff3_tool_selection_changed(GtkFileChooser* filechooser, gpointer user_data) {
  MODEL* m = (MODEL*)model;
  gchar* name = gtk_file_chooser_get_filename(filechooser);
  if(name != NULL) {
    g_string_assign(m->diff3_tool, name);
  }
}

static void
set_filter(GtkFileChooser* filechooser) {
  GtkFileFilter* filter = gtk_file_filter_new();
  gtk_file_filter_add_mime_type(filter, "application/x-executable");
  gtk_file_chooser_set_filter(filechooser, filter);
}

void
on_diff_tool_realize(GtkWidget* widget, gpointer user_data) {
  MODEL* m = (MODEL*)model;
  set_filter((GtkFileChooser*)widget);
  gtk_file_chooser_set_filename((GtkFileChooser*)widget, m->diff_tool->str);
}

void
on_diff3_tool_realize(GtkWidget* widget, gpointer user_data) {
  MODEL* m = (MODEL*)model;
  set_filter((GtkFileChooser*)widget);
  gtk_file_chooser_set_filename((GtkFileChooser*)widget, m->diff3_tool->str);
}

void
on_3_way_compare_realize(GtkWidget* widget, gpointer user_data) {
  MODEL* m = (MODEL*)model;
  gtk_toggle_button_set_active((GtkToggleButton*)widget, m->enable_diff3);
}

void
mime_type_enable_toggled(GtkCellRendererToggle* renderer, const char* path, GtkTreeView* tree_view) {
  GtkTreeModel* model;
  GtkTreeIter iter;
  
  model = gtk_tree_view_get_model(tree_view);
  
  if(gtk_tree_model_get_iter_from_string(model, &iter, path)) {
    gboolean enabled;
    
    gtk_tree_model_get(model, &iter, ENABLE_GDIFF_EXT, &enabled, -1);
    enabled = !enabled;
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, ENABLE_GDIFF_EXT, enabled, -1);
  }
}

void
on_mime_types_realize(GtkWidget* widget, gpointer user_data) {
  GtkCellRenderer* renderer;
  GtkTreeView* view = GTK_TREE_VIEW(widget);
  GConfClient* gconf_client;
  gint column_no;
  GtkTreeViewColumn* column;

  gconf_client = gconf_client_get_default ();
  g_object_unref(G_OBJECT(gconf_client));
  
  /* --- Column #1 --- */
  renderer = gtk_cell_renderer_toggle_new();
  column_no = gtk_tree_view_insert_column_with_attributes(view,
    -1,
    "",
    renderer,
    "active", ENABLE_GDIFF_EXT,
    NULL);
  g_signal_connect(G_OBJECT(renderer), "toggled", G_CALLBACK(mime_type_enable_toggled), view);
  column = gtk_tree_view_get_column(view, column_no-1);
  gtk_tree_view_column_set_sort_column_id(column, ENABLE_GDIFF_EXT);
  
  /* --- Column #2 --- */
  renderer = gtk_cell_renderer_text_new();
  column_no = gtk_tree_view_insert_column_with_attributes(view,
    -1,
    "MIME Type",
    renderer,
    "text", MIME_TYPE,
    NULL);
  column = gtk_tree_view_get_column(view, column_no-1);
  gtk_tree_view_column_set_resizable(column, TRUE);
  gtk_tree_view_column_set_sort_column_id(column, MIME_TYPE);
  
  /* --- Column #3 --- */
  renderer = gtk_cell_renderer_text_new();
  column_no = gtk_tree_view_insert_column_with_attributes(view,
    -1,
    "Description",
    renderer,
    "text", MIME_DESCRIPTION,
    NULL);
  column = gtk_tree_view_get_column(view, column_no-1);
  gtk_tree_view_column_set_resizable(column, TRUE);
  gtk_tree_view_column_set_sort_column_id(column, MIME_DESCRIPTION);
    
  gtk_tree_view_set_model(view, GTK_TREE_MODEL(list_model));
  
  g_object_unref(list_model);
}

