/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "historywidget.h"
#include "sidebarwidget.h"

HistoryWidget::HistoryWidget(QWidget* parent) :
	SidebarWidgetBase(parent)
{
	m_wtype = BuiltinPlaces;
	m_title = QString("History");
	setSizePolicy( QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Expanding) );
}

HistoryWidget::~ HistoryWidget()
{
}

bool HistoryWidget::loadWidget(QWidget* /*parent*/)
{
	return true;
}

bool HistoryWidget::unloadWidget()
{
	return true;
}

QSize HistoryWidget::sizeHint() const
{
	QSize sizeHint = QWidget::sizeHint();
	int ems = QWidget::fontMetrics().width("mmmmmmmmmmmmmmmm");
	if (sizeHint.width() < ems)
	{
		sizeHint.setWidth(ems);
	}
	return sizeHint;
}

#include "historywidget.moc"
