/***************************************************************************
 *   Copyright (C) 2006 by Cvetoslav Ludmiloff <ludmiloff@gmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qpixmap.h>
#include <kiconloader.h>

#include "sidebar.h"
#include "widgetselector.h"
#include "myplaces.h"
#include "historywidget.h"

Sidebar::Sidebar(QWidget* parent, Mode mode) :
    QWidget(parent),
    m_mode(mode)
{
    m_layout = new QVBoxLayout(this);
	m_toplayout = new QHBoxLayout(m_layout);

    // create widget selector
    m_selector = new WidgetSelector(this);
	connect (this, SIGNAL(widgetRegistered( const QString& )),
		m_selector, SLOT(newWidgetRegistered( const QString& )));
	connect(m_selector, SIGNAL(widgetChangeRequest(const QString&)),
		this, SLOT(changeWidget(const QString&)));
	connect(this, SIGNAL(widgetChanged(const QString&, uint)),
		m_selector, SLOT(slotSetCurrentWidget(const QString&, uint)));

	m_toplayout->addWidget(m_selector, 2);
	m_toplayout->addSpacing(10);

	QToolButton* closeButton = new QToolButton(this);
	closeButton->setIconSet(SmallIcon("exit"));
	closeButton->setAutoRaise(true);
	m_toplayout->addWidget(closeButton, 0);

	if (createBuiltinWidgets() && createPluginWidgets()) {
		// TODO: get last used widget from settings
        m_currentWidget = m_widgetCollection.find("My places");
        if (m_currentWidget != 0) {
			// TODO: FIXME: move this code to the changeWidgetSlot
			m_selector->slotSetCurrentWidget(m_currentWidget->title(), m_currentWidget->wtype());
			// TODO: connect all other signals and slots (when they are ready)
			connect(m_currentWidget, SIGNAL(urlChangeRequest(const KURL&)),
				this, SLOT(urlRequest(const KURL&)));
			m_currentWidget->show();
			m_layout->addWidget(m_currentWidget, 1);
		}

	}
}


Sidebar::~Sidebar()
{
}

void Sidebar::changeWidget(const QString& key)
{
    SidebarWidgetBase* new_widget = m_widgetCollection.find(key);
	if (new_widget != 0) {
		// TODO: FIXME: check if new widget is m_currentWidget one

		// disconnect all signals and slots from the current widget
		disconnect(m_currentWidget, 0, 0, 0);

		// remove current widget and replace with desired one
		m_currentWidget->hide();
		m_layout->remove(m_currentWidget);
		m_currentWidget = new_widget;
		m_layout->addWidget(m_currentWidget, 1);
		m_currentWidget->show();
		// connect the signals and slots again
		connect(m_currentWidget, SIGNAL(urlChangeRequest(const KURL&)),
			this, SLOT(urlRequest(const KURL&)));
		// TODO: connect all other signals and slots (when they are ready

		// optionaly emit siganl to the parent about new widget selected
		emit widgetChanged(key, new_widget->wtype());
	}
}

bool Sidebar::registerWidget(const QString& /*library*/)
{
	// nothing to do for now
	return true;
}


bool Sidebar::createPluginWidgets()
{
	// nothin to do for now
	return true;
}

bool Sidebar::createBuiltinWidgets()
{
	// my places widget
	MyPlacesWidget* myplaces = new MyPlacesWidget(true, this);
	myplaces->hide();
	m_widgetCollection.insert(myplaces->title(), myplaces);
	emit widgetRegistered(myplaces->title());

	// history widget
	HistoryWidget* history = new HistoryWidget(this);
	history->hide();
	m_widgetCollection.insert(history->title(), history);
	emit widgetRegistered(history->title());

	// TODO: notes widget and so on

	return true;
}

void Sidebar::urlRequest(const KURL& url)
{
	emit urlChanged(url);
}

/*
QSize Sidebar::sizeHint() const
{
	QSize thisSizeHint = QWidget::sizeHint();
	return thisSizeHint;
	if (m_widget)
	{
		QSize sizeHint = m_widget->sizeHint();
		return sizeHint;
	} else {
		return QWidget::sizeHint();
	}
}

*/
