#!/usr/bin/env python

# Dosage, the webcomic downloader
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
from distutils.core import setup
from distutils.command.build_scripts import build_scripts

execfile('dosage/version.py')

if os.name == "nt":
    class build_scripts_rename(build_scripts):
        """Renames scripts so they end with '.py' on Windows."""

        def run(self):
            build_scripts.run(self)
            for f in os.listdir(self.build_dir):
                fpath = os.path.join(self.build_dir, f)
                if not fpath.endswith('.py'):
                    if os.path.exists(fpath + '.py'):
                        os.unlink(fpath + '.py')
                    os.rename(fpath, fpath + '.py')
else:
    build_scripts_rename = build_scripts

args = {
    'name': 'Dosage',
    'version': VERSION,
    'description': 'Dosage is a utility for archiving webcomics locally',
    'author': 'Tristan Seligmann and Jonathan Jacobs',
    'author_email': 'mithrandi@mithrandi.za.net',
    'maintainer': 'Tristan Seligmann',
    'maintainer_email': 'mithrandi@mithrandi.za.net',
    'url': 'http://slipgate.za.net/dosage',
    'license': 'GNU GPL',
    'packages': (
        'dosage',
        'dosage.modules',
        'dosage.modules.helpers',
    ),
    'scripts': (
        'bin/mainline',
    ),
    'cmdclass': {
        'build_scripts': build_scripts_rename,
    },
}

if __name__ == '__main__':
    setup(**args)
