from re import compile, MULTILINE

from dosage.helpers import BasicScraper, regexNamer, bounceStarter


class ALessonIsLearned(BasicScraper):
    latestUrl = 'http://www.alessonislearned.com/'
    imageUrl = 'http://www.alessonislearned.com/lesson%s.html'
    imageSearch = compile(r'<img src="(cmx/.+?)"')
    prevSearch = compile(r"<a href='(index.php\?comic=.+?)'.+?previous")
    help = 'Index format: nnn'


class ASofterWorld(BasicScraper):
    latestUrl = 'http://www.asofterworld.com/'
    imageUrl = 'http://www.asofterworld.com/index.php?id=%s'
    imageSearch = compile(r'<img src="(http://www.asofterworld.com/clean/.*?)"')
    prevSearch = compile(r'"(.*?)">.*?back')
    help = 'Index format: n (unpadded)'


class AbleAndBaker(BasicScraper):
    latestUrl = 'http://www.jimburgessdesign.com/comics/index.php'
    imageUrl = 'http://www.jimburgessdesign.com/comics/index.php?comic=%s'
    imageSearch = compile(r'<img src="(comics/.+?)"')
    prevSearch = compile(r'<a href="(.+\d+?)".+previous.gif')
    help = 'Index format: nnn'


class AbstractGender(BasicScraper):
    latestUrl = 'http://www.abstractgender.com/'
    imageUrl = 'http://www.abstractgender.com/?comic=%s'
    imageSearch = compile(r'<img[^>]+src="(comics/\d+\.\w+)"')
    prevSearch = compile(r'<a\W+href="(\?comic=\d+)"><img[^>]+id="comic_menu_prev"')
    help = 'Index format: n (unpadded)'


class AbsurdNotions(BasicScraper):
    latestUrl = 'http://www.absurdnotions.org/'
    imageUrl = 'http://www.absurdnotions.org/page%s.html'
    imageSearch = compile(r'<IMG SRC="(an\d+.?\..+?)"')
    prevSearch = compile(r'<A.*?HREF="(page\d+\.html)"><img SRC="nprev\.gif"')
    help = 'Index format: n (unpadded)'


class AcademyVale(BasicScraper):
    latestUrl = 'http://imagerie.com/vale/'
    imageUrl = 'http://imagerie.com/vale/avarch.cgi?%s'
    imageSearch = compile(r'<IMG.+?SRC="(avale\d{4}-\d{2}\..*?)"')
    prevSearch = compile(r'HREF=(avarch.*?)><IMG SRC="AVNavBack.gif"')
    help = 'Index format: nnn'


class AlienLovesPredator(BasicScraper):
    latestUrl = 'http://alienlovespredator.com/index.php'
    imageUrl = 'http://alienlovespredator.com/index.php?id=%s'
    imageSearch = compile(r'<img src="(http://planetavp\.com/alienlovespredator/strips/.+?)" width')
    prevSearch = compile(r'<a href="(/index\.php\?id=\d+?)".+?nav_previous')
    help = 'Index format: nnn'


class Altermeta(BasicScraper):
    latestUrl = 'http://www.altermeta.com/'
    imageUrl = 'http://www.altermeta.com/index.php?PS=viewComic.php&comic=%s'
    imageSearch = compile(r'<img.+?src="(comics/\d+_\d+\..+?)"')
    prevSearch = compile(r'<a href="(index\.php\?PS=viewComic\.php&comic=\d+)">Previous')
    help = 'Index format: n (unpadded)'


class Angels2200(BasicScraper):
    latestUrl = 'http://peter.haynes.iconz.co.nz/'
    imageUrl = 'http://peter.haynes.iconz.co.nz/Default.asp?ID=%s'
    imageSearch = compile(r'(/archives/.+?)"')
    prevSearch = compile(r'(/Default.asp\?ID=\d+?)".+previous.jpg')
    help = 'Index format: nnn'


class AnimeArcadia(BasicScraper):
    latestUrl = 'http://www.animearcadia.com/index.php?p=comics'
    imageUrl = 'http://www.animearcadia.com/index.php?p=comics&c=%s'
    imageSearch = compile(r'(/comics/.+?)"')
    prevSearch = compile(r'First.+?"(index.php\?p=comics&c=.+?)".+?Back')
    help = 'Index format: n (unpadded)'


class AppleGeeks(BasicScraper):
    latestUrl = 'http://www.applegeeks.com/'
    imageUrl = 'http://www.applegeeks.com/comics/viewcomic.php?issue=%s'
    imageSearch = compile(r'<img src="((?:/comics/)?issue\d+?\..+?)"')
    prevSearch = compile(r'<div class="caption">Previous Comic</div>\s*<p><a href="([^"]+)">', MULTILINE)
    help = 'Index format: n (unpadded)'


class AppleGeeksLite(BasicScraper):
    latestUrl = 'http://www.applegeeks.com/lite/'
    imageUrl = 'http://applegeeks.com/lite/index.php?aglitecomic=%s'
    imageSearch = compile(r'<img src="(strips/.+?)"')
    prevSearch = compile(r'<a href="(index.php\?aglitecomic=.+?)".+?back')
    help = 'Index format: yyyy-mm-dd'


class AsIf(BasicScraper):
    latestUrl = 'http://asifcomic.com/404.html'
    imageUrl = 'http://www.asifcomic.com/%s.html'
    imageSearch = compile(r'<img src="((?:\.\./)*strips/\d+\..+?)"')
    prevSearch = compile(r'<a href="(?:\.\./)*(\d+\..+?)"><img[^>]*src="(?:\.\./)*previous\.jpg"')
    help = 'Index format: nn(n) (padded up to a maximum of 2 characters)'


class Achewood(BasicScraper):
    latestUrl = 'http://www.achewood.com/'
    imageUrl = 'http://www.achewood.com/index.php?date=%s'
    imageSearch = compile(r'<img src="(http://m.assetbar.com/achewood/autaux.+?)"')
    prevSearch = compile(r'<a href="(/index\.php\?date=\d{8})"[^>]*>&lt;-</a>')
    help = 'Index format: mmddyyyy'
    namer = regexNamer(compile(r'date%3D(\d{8})'))


class AstronomyPOTD(BasicScraper):
    starter = bounceStarter('http://antwrp.gsfc.nasa.gov/apod/astropix.html', compile(r'<a href="(ap\d{6}\.html)">&gt;</a>'))
    imageUrl = 'http://antwrp.gsfc.nasa.gov/apod/ap%s.html'
    imageSearch = compile(r'<a href="(image/\d{4}/.+\..+?)">')
    prevSearch = compile(r'<a href="(ap\d{6}\.html)">&lt;</a>')
    help = 'Index format: yymmdd'

    def namer(cls, imageUrl, pageUrl):
        return '%s-%s' % (pageUrl.split('/')[-1].split('.')[0][2:], imageUrl.split('/')[-1].split('.')[0])
