.\" dpkg manual page - deb-prerm(5)
.\"
.\" Copyright © 2016 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb\-prerm 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
deb\-prerm \- package pre-removal maintainer script
.
.SH SYNOPSIS
prerm
.
.SH DESCRIPTION
A package can perform several pre-removal actions via maintainer
scripts, by including an executable \fIprerm\fP file in its control
archive (i.e. \fIDEBIAN/prerm\fP during package creation).
.PP
The script can be called in the following ways:
.TP
\fIprerm\fP \fBremove\fP
Before the package is removed.
.TP
\fIold-prerm\fP \fBupgrade\fP \fInew-version\fP
Before an upgrade.
.TP
\fInew-prerm\fP \fBfailed-upgrade\fP \fIold-version new-version\fP
If the above \fBupgrade\fP fails.
.TP
\fIprerm\fP \fBdeconfigure in-favour\fP \fInew-package new-version\fP
.TQ
    [ \fBremoving\fP \fIold-package old-version\fP ]
Before package is deconfigured while dependency is replaced due to conflict.
.TP
\fIprerm\fP \fBremove in-favour\fP \fInew-package new-version\fP
Before the package is replaced due to conflict.
.
.SH SEE ALSO
.BR dpkg (1).
