/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/
#include <string>
#include <stdlib.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtextbrowser.h>
#include <vector>
#include <avifile/avifile.h>
#include <avifile/creators.h>
#include <avifile/image.h>

#include "QCodecConfigImpl.h"


#define null_value "n/a"

/* 
 *  Constructs a QCodecConfigImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
QCodecConfigImpl::QCodecConfigImpl( QWidget* parent,  const char* name)
    : QCodecConfig( parent, name ) {}

QCodecConfigImpl::QCodecConfigImpl(int fourcc, QWidget* parent,  const char* name )
    : QCodecConfig( parent, name ), compressor(fourcc)
{
//	const CodecInfo* ci=0;
	
	avm::vector<CodecInfo>::iterator it_ci;

	for(it_ci=video_codecs.begin(); it_ci!=video_codecs.end(); it_ci++) {
		if(!it_ci->direction & CodecInfo::Encode) continue;
		qlb_codec_list->insertItem(QString(it_ci->GetName()), 0);
		if(it_ci->fourcc==compressor) {
			qlb_codec_list->setSelected(0, true);
		}
	}
	
	qlb_codec_list->sort();
}



/*  
 *  Destroys the object and frees any allocated resources
 */
QCodecConfigImpl::~QCodecConfigImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void QCodecConfigImpl::setVideoCodecName(const string &vcn) {
	video_codec_name=vcn;
	avm::vector<CodecInfo>::iterator it_ci;
	CodecInfo::match(0xffffffff, CodecInfo::Video, NULL);
	
	for(it_ci=video_codecs.begin(); it_ci!=video_codecs.end(); it_ci++) {
		if(!(it_ci->direction & CodecInfo::Encode)) continue;
		qlb_codec_list->insertItem(it_ci->GetName(), 0);
		if(it_ci->GetName()==video_codec_name) {
			compressor=it_ci->fourcc;
			qlb_codec_list->setSelected(0, true);
		}
	}
	
	qlb_codec_list->sort();
}

void QCodecConfigImpl::changeCodec() {
	// search fot the fourcc of the selected codec
	avm::vector<CodecInfo>::iterator it_ci;

	video_codec_name=(const char*)qlb_codec_list->currentText();
	
	for(it_ci=video_codecs.begin(); it_ci!=video_codecs.end(); it_ci++) {
		if(QString::compare(it_ci->GetName(),video_codec_name.c_str())==0) break;
	}

	compressor=it_ci->fourcc;
	qlb_attribute_about->setText("");
	qle_attribute_value->setEnabled(false);
	qle_attribute_value->setText("");

	// attributs list update
	qlv_attribute_list->clear();
	QListViewItem *a;
	avm::vector<AttributeInfo>::iterator it_a;
	for(it_a=it_ci->encoder_info.begin(); it_a!=it_ci->encoder_info.end(); it_a++) {
		QString string_value;
		int tmp_int;
		const char *tmp_char;
    float tmp_float;

		switch(it_a->kind) {
    case AttributeInfo::Float:
			if(CodecGetAttr(*it_ci, it_a->GetName(), &tmp_float)) {
				string_value=null_value;
			} else {
				string_value=QString::number(double(tmp_float));
			}
			break;
		case AttributeInfo::Integer :	
			if(CodecGetAttr(*it_ci, it_a->GetName(), &tmp_int)) {
				string_value=null_value;
			} else {
				string_value=QString::number(tmp_int);
			}
			break;
		case AttributeInfo::String:		
			if(CodecGetAttr(*it_ci, it_a->GetName(), &tmp_char)) {
				string_value=null_value;
			} else {
				string_value=tmp_char;
			}
			break;
		case AttributeInfo::Select:	
			string_value=null_value;
			break;
		}
		a=new QListViewItem(qlv_attribute_list, it_a->GetName(), string_value, "");
		qlv_attribute_list->insertItem(a);
		qle_attribute_value->setEnabled(true);
	}

	qlv_attribute_list->sort();

	qlv_attribute_list->setSelected(qlv_attribute_list->firstChild(), true);

	qtb_codec_about->setText(it_ci->GetAbout());
}

void QCodecConfigImpl::changeAttribute(QListViewItem *i) {
	qle_attribute_value->setText(i->text(1));

	avm::vector<CodecInfo>::iterator it_ci;
	for(it_ci=video_codecs.begin(); it_ci!=video_codecs.end(); it_ci++) {
		if(QString::compare(it_ci->GetName(),video_codec_name.c_str())==0) break;
	}

	avm::vector<AttributeInfo>::iterator it_a;
	for(it_a=it_ci->encoder_info.begin(); it_a!=it_ci->encoder_info.end(); it_a++) {
		if(QString::compare(it_a->GetName(), i->text(0))==0) {
			current_attribute_kind=it_a->kind;
			qlb_attribute_about->setText(it_a->GetAbout());
			break;
		}
	}
}

void QCodecConfigImpl::setAttribute() {
	if(QString::compare(qle_attribute_value->text(), null_value) && QString::compare(qle_attribute_value->text(), "")) {
		
		avm::vector<CodecInfo>::iterator it_ci;
		for(it_ci=video_codecs.begin(); it_ci!=video_codecs.end(); it_ci++) {
			if(QString::compare(it_ci->GetName(),video_codec_name.c_str())==0) break;
		}

		switch(current_attribute_kind) {
		case AttributeInfo::Float :	
			CodecSetAttr(*it_ci, qlv_attribute_list->currentItem()->text(0), qle_attribute_value->text().toFloat());
			break;
    case AttributeInfo::Integer:
			CodecSetAttr(*it_ci, qlv_attribute_list->currentItem()->text(0), qle_attribute_value->text().toInt());
			break;
		case AttributeInfo::String:		
			CodecSetAttr(*it_ci, qlv_attribute_list->currentItem()->text(0), qle_attribute_value->text());
			break;
		case AttributeInfo::Select:	
			//don't now what to do
			break;
		}
		changeCodec();
	}
}

void QCodecConfigImpl::changeParameter() {
	emit(parameterChanged());
}
