# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import gobject
gobject.threads_init()
import sys

from elisa.core import log
log.init()
log.logTwisted()

try:
    from twisted.internet import glib2reactor
    glib2reactor.install()
except AssertionError:
    # reactor already installed
    pass

from elisa.plugins.gstreamer_plugin.gst_metadata import \
        GstMetadata, GstMetadataFast

from elisa.core.media_uri import MediaUri

import sys
from twisted.internet import reactor
from twisted.spread import pb, flavors, jelly
from twisted.internet.stdio import StandardIO

class GstMetadataBroker(pb.Broker):
    def __init__(self, is_client=False):
        pb.Broker.__init__(self, is_client, jelly.DummySecurityOptions())

    def connectionLost(self, reason):
        pb.Broker.connectionLost(self, reason)

        reactor.stop()

class GstMetadataPBRoot(flavors.Root):
    def __init__(self):
        self.component = GstMetadataFast()
    
    def remote_initialize(self):
        return self.component.initialize()

    def remote_clean(self):
        return self.component.clean()

    def remote_able_to_handle(self, metadata):
        return self.component.able_to_handle(metadata)

    def remote_get_metadata(self, metadata, low_priority=False):
        dfr = self.component.get_metadata(metadata, low_priority)
        return dfr

def main():
    # we are being run out of process, run perspective broker over stdin/stdout
    # to communicate with elisa
    root = GstMetadataPBRoot()
    factory = pb.PBServerFactory(root)
    factory.protocol = GstMetadataBroker
    protocol = factory.buildProtocol(None)
    transport = StandardIO(protocol)
    reactor.run()

if __name__ == '__main__':
    sys.exit(main())

