/*
			    Endeavour Mount Bar
 */

#ifndef MOUNTBAR_H
#define MOUNTBAR_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvdevices.h"


typedef struct _edv_mountbar_struct	edv_mountbar_struct;


/*
 *	Mount Bar:
 */
struct _edv_mountbar_struct {

	GtkWidget	*toplevel;
	gint		freeze_count;
	gpointer	core_ptr;
	GdkGC		*gc;

	GtkWidget	*dev_da,	/* Selected device GtkDrawingArea */
			*map_btn,	/* Map devices Popup List GtkButton */
			*mount_btn,	/* Mount/Unmount GtkButton */
			*eject_btn,	/* Eject GtkButton */
			*refresh_btn,	/* Refresh GtkButton */
			*goto_btn,	/* GoTo Mount Path GtkButton */
			*properties_btn,	/* Mount Path Properties GtkButton */
			*fsck_btn,	/* FSCK GtkButton */
			*tools_btn,	/* Tools GtkButton */
			*format_btn,	/* Format GtkButton */
			*stats_da;	/* Stats GtkDrawingArea */

	/* Selected device index or -1 for none */
	gint		selected_dev_num;

	/* Selected device values */
	gchar		*dev_text;
	GdkPixmap	*dev_pixmap;
	GdkBitmap	*dev_mask;

	/* Selected device stats values */
	gint		dev_stats_page;
	gfloat		dev_stats_used_coeff;
	gchar		*dev_stats_label;

	/* Mount/Unmount callback */
	void	(*mount_cb)(
		edv_mountbar_struct *,	/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	/* Eject callback */
	void	(*eject_cb)(
		edv_mountbar_struct *,	/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	/* Goto mount path callback */
	void	(*goto_cb)(
		edv_mountbar_struct *,	/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	/* Status message callback */
	void	(*status_message_cb)(
		const gchar *,		/* Message */
		gpointer		/* Data */
	);
	gpointer	data;

};
#define EDV_MOUNTBAR(p)		((edv_mountbar_struct *)(p))


extern edv_mountbar_struct *EDVMountBarNew(
	gpointer core_ptr, GtkWidget *parent,
	void (*mount_cb)(
		edv_mountbar_struct *, gint, edv_device_struct *,
		gpointer
	),
	void (*eject_cb)(
		edv_mountbar_struct *, gint, edv_device_struct *,
		gpointer
	),
	void (*goto_cb)(
		edv_mountbar_struct *, gint, edv_device_struct *,
		gpointer
	),
	void (*status_message_cb)(const gchar *, gpointer),
	gpointer data
);
extern void EDVMountBarUpdateMenus(edv_mountbar_struct *mb);
extern void EDVMountBarMap(edv_mountbar_struct *mb);
extern void EDVMountBarUnmap(edv_mountbar_struct *mb);
extern void EDVMountBarDelete(edv_mountbar_struct *mb);


#endif	/* MOUNTBAR_H */
