/*
		      Endeavour Browser Operation Callbacks
 */

#ifndef BROWSER_OP_CB_H
#define BROWSER_OP_CB_H

#include <gtk/gtk.h>
#include "toolbar.h"
#include "edv_types.h"
#include "edv_device.h"
#include "edv_mount_bar.h"
#include "edv_find_bar.h"
#include "edv_status_bar.h"
#include "browser.h"


extern void EDVBrowserOPCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVBrowserOPEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVBrowserOPLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
);

extern void EDVBrowserOPClose(edv_browser_struct *browser);
extern void EDVBrowserOPExit(edv_browser_struct *browser);

extern void EDVBrowserOPSyncDisks(edv_browser_struct *browser);
extern void EDVBrowserOPRun(edv_browser_struct *browser);
extern void EDVBrowserOPWriteProtect(edv_browser_struct *browser);
extern void EDVBrowserOPDeleteMethodRecycle(edv_browser_struct *browser);
extern void EDVBrowserOPDeleteMethodPurge(edv_browser_struct *browser);

extern void EDVBrowserOPNewObject(
	edv_browser_struct *browser, toolbar_item_struct *item
);
extern void EDVBrowserOPNewFile(edv_browser_struct *browser);
extern void EDVBrowserOPNewDirectory(edv_browser_struct *browser);
extern void EDVBrowserOPNewLink(edv_browser_struct *browser);
extern void EDVBrowserOPNewFifo(edv_browser_struct *browser);
extern void EDVBrowserOPNewDeviceBlock(edv_browser_struct *browser);
extern void EDVBrowserOPNewDeviceCharacter(edv_browser_struct *browser);
extern void EDVBrowserOPNewSocket(edv_browser_struct *browser);

extern void EDVBrowserOPOpen(edv_browser_struct *browser);
extern void EDVBrowserOPOpenTo(
	edv_browser_struct *browser, toolbar_item_struct *item
);
extern void EDVBrowserOPOpenWith(edv_browser_struct *browser);

extern void EDVBrowserOPCopyPath(edv_browser_struct *browser);
extern void EDVBrowserOPCopyURL(edv_browser_struct *browser);        
extern void EDVBrowserOPPaste(edv_browser_struct *browser);

extern void EDVBrowserOPMove(edv_browser_struct *browser);
extern void EDVBrowserOPCopy(edv_browser_struct *browser);
extern void EDVBrowserOPLink(edv_browser_struct *browser);
extern void EDVBrowserOPRename(edv_browser_struct *browser);
extern void EDVBrowserOPChMod(edv_browser_struct *browser);
extern void EDVBrowserOPChOwn(edv_browser_struct *browser);
extern void EDVBrowserOPChTime(edv_browser_struct *browser);
extern void EDVBrowserOPDelete(edv_browser_struct *browser);
extern void EDVBrowserOPProperties(edv_browser_struct *browser);

extern void EDVBrowserOPSelectAll(edv_browser_struct *browser);
extern void EDVBrowserOPUnselectAll(edv_browser_struct *browser);
extern void EDVBrowserOPInvertSelection(edv_browser_struct *browser);

extern void EDVBrowserOPDownload(edv_browser_struct *browser);

extern void EDVBrowserOPRefresh(edv_browser_struct *browser);
extern void EDVBrowserOPRefreshAll(edv_browser_struct *browser);
extern void EDVBrowserOPGoToParent(edv_browser_struct *browser);
extern void EDVBrowserOPExpand(edv_browser_struct *browser);

extern void EDVBrowserContentsFilter(edv_browser_struct *browser);

extern void EDVBrowserOPDirectoryTreeOrigin(edv_browser_struct *browser);

extern void EDVBrowserOPMount(edv_browser_struct *browser);
extern void EDVBrowserOPEject(edv_browser_struct *browser);

extern void EDVBrowserMIMETypes(edv_browser_struct *browser);


#endif	/* BROWSER_OP_CB_H */
