/*
                           Endeavour Confirmation

	Uses the confirmation dialog to query the user on various
	operations.
 */

#ifndef EDV_CONFIRM_H
#define EDV_CONFIRM_H

#include <gtk/gtk.h>

#include "url.h"
#include "edv_types.h"
#include "edv_obj.h"


extern gint EDVConfirmLink(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmMove(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmCopy(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmDelete(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects
);

extern gint EDVConfirmArchiveAdd(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *arch_path
);
extern gint EDVConfirmArchiveExtract(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmArchiveDelete(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, gint total_objects
);

extern gint EDVConfirmRecover(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path,		/* String containing index number. */
	gint total_objects,
	const gchar *tar_path
);
extern gint EDVConfirmPurge(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path,		/* String containing index number. */
	gint total_objects
);

extern gint EDVConfirmDND(
	edv_core_struct *core,
	const gint gdk_action, const guint info,
	GtkWidget *toplevel,
	GList *url_list,
	const gchar *tar_path
);




#endif	/* EDV_CONFIRM_H */
